/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.validation.zeebe;

import io.zeebe.model.bpmn.instance.Process;
import io.zeebe.model.bpmn.instance.StartEvent;
import java.util.Collection;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class ProcessValidator
implements ModelElementValidator<Process> {
    public Class<Process> getElementType() {
        return Process.class;
    }

    public void validate(Process element, ValidationResultCollector validationResultCollector) {
        Collection topLevelStartEvents = element.getChildElementsByType(StartEvent.class);
        if (topLevelStartEvents.size() == 0) {
            validationResultCollector.addError(0, "Must have at least one start event");
        } else if (topLevelStartEvents.size() > 1 && topLevelStartEvents.stream().anyMatch(this::isNoneEvent)) {
            validationResultCollector.addError(0, "Must be either one none start event or multiple message/timer start events");
        }
    }

    private boolean isNoneEvent(StartEvent startEvent) {
        return startEvent.getEventDefinitions().isEmpty();
    }
}

