/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.validation.zeebe;

import io.zeebe.model.bpmn.instance.BoundaryEvent;
import io.zeebe.model.bpmn.instance.EventDefinition;
import io.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.zeebe.model.bpmn.instance.TimerEventDefinition;
import java.util.Collection;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class BoundaryEventValidator
implements ModelElementValidator<BoundaryEvent> {
    public Class<BoundaryEvent> getElementType() {
        return BoundaryEvent.class;
    }

    public void validate(BoundaryEvent element, ValidationResultCollector validationResultCollector) {
        if (element.getAttachedTo() == null) {
            validationResultCollector.addError(0, "Must be attached to an activity");
        }
        if (element.getIncoming().size() > 0) {
            validationResultCollector.addError(0, "Cannot have incoming sequence flows");
        }
        if (element.getOutgoing().size() < 1) {
            validationResultCollector.addError(0, "Must have at least one outgoing sequence flow");
        }
        this.validateEventDefinition(element, validationResultCollector);
    }

    private void validateEventDefinition(BoundaryEvent element, ValidationResultCollector validationResultCollector) {
        Collection<EventDefinition> eventDefinitions = element.getEventDefinitions();
        if (eventDefinitions.size() != 1) {
            validationResultCollector.addError(0, "Must have exactly one event definition");
        } else {
            EventDefinition eventDefinition = eventDefinitions.iterator().next();
            SupportLevel supportLevel = this.getSupportLevel(eventDefinition);
            this.validateSupportLevel(element, validationResultCollector, supportLevel);
        }
    }

    private SupportLevel getSupportLevel(EventDefinition eventDefinition) {
        if (eventDefinition instanceof MessageEventDefinition) {
            return SupportLevel.All;
        }
        if (eventDefinition instanceof TimerEventDefinition) {
            TimerEventDefinition timerEventDefinition = (TimerEventDefinition)eventDefinition;
            if (timerEventDefinition.getTimeCycle() != null) {
                return SupportLevel.NonInterrupting;
            }
            return SupportLevel.All;
        }
        return SupportLevel.None;
    }

    private void validateSupportLevel(BoundaryEvent element, ValidationResultCollector validationResultCollector, SupportLevel supportLevel) {
        switch (supportLevel) {
            case None: {
                validationResultCollector.addError(0, "Boundary events must be one of: timer, message");
                break;
            }
            case Interrupting: {
                if (element.cancelActivity()) break;
                validationResultCollector.addError(0, "Non-interrupting events of this type are not supported");
                break;
            }
            case NonInterrupting: {
                if (!element.cancelActivity()) break;
                validationResultCollector.addError(0, "Interrupting events of this type are not supported");
                break;
            }
        }
    }

    public static enum SupportLevel {
        None,
        Interrupting,
        NonInterrupting,
        All;

    }
}

