/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.util.time;

import io.zeebe.model.bpmn.util.time.Interval;
import io.zeebe.model.bpmn.util.time.Timer;
import java.time.format.DateTimeParseException;
import java.util.Objects;

public class RepeatingInterval
implements Timer {
    public static final String INTERVAL_DESGINATOR = "/";
    public static final int INFINITE = -1;
    private final int repetitions;
    private final Interval interval;

    public RepeatingInterval(int repetitions, Interval interval) {
        this.repetitions = repetitions;
        this.interval = interval;
    }

    @Override
    public int getRepetitions() {
        return this.repetitions;
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public long getDueDate(long fromEpochMillis) {
        return this.getInterval().toEpochMilli(fromEpochMillis);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RepeatingInterval)) {
            return false;
        }
        RepeatingInterval repeatingInterval = (RepeatingInterval)o;
        return this.getRepetitions() == repeatingInterval.getRepetitions() && Objects.equals(this.getInterval(), repeatingInterval.getInterval());
    }

    public int hashCode() {
        return Objects.hash(this.getRepetitions(), this.getInterval());
    }

    public static RepeatingInterval parse(String text) {
        return RepeatingInterval.parse(text, INTERVAL_DESGINATOR);
    }

    public static RepeatingInterval parse(String text, String intervalDesignator) {
        if (!text.startsWith("R")) {
            throw new DateTimeParseException("Repetition spec must start with R", text, 0);
        }
        int intervalDesignatorOffset = text.indexOf(intervalDesignator);
        if (intervalDesignatorOffset == -1) {
            throw new DateTimeParseException("No interval given", text, intervalDesignatorOffset);
        }
        if (intervalDesignatorOffset == 1) {
            return new RepeatingInterval(-1, Interval.parse(text.substring(2)));
        }
        try {
            return new RepeatingInterval(Integer.parseInt(text.substring(1, intervalDesignatorOffset)), Interval.parse(text.substring(intervalDesignatorOffset + 1)));
        }
        catch (NumberFormatException e) {
            throw new DateTimeParseException("Cannot parse repetitions count", text, 1, e);
        }
    }
}

