/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.util.time;

import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Interval
implements TemporalAmount {
    private static final Duration ACCURATE_DURATION_UPPER_BOUND = Duration.ofDays(1L);
    private final List<TemporalUnit> units;
    private final Period period;
    private final Duration duration;

    public Interval(Period period, Duration duration) {
        this.period = period;
        this.duration = duration;
        this.units = new ArrayList<TemporalUnit>();
        this.units.addAll(period.getUnits());
        this.units.addAll(duration.getUnits());
    }

    public Period getPeriod() {
        return this.period;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public long toEpochMilli(long fromEpochMilli) {
        if (!this.isCalendarBased()) {
            return fromEpochMilli + this.getDuration().toMillis();
        }
        Instant start = Instant.ofEpochMilli(fromEpochMilli);
        ZonedDateTime zoneAwareStart = ZonedDateTime.ofInstant(start, ZoneId.systemDefault());
        return zoneAwareStart.plus(this).toInstant().toEpochMilli();
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit.SECONDS || unit == ChronoUnit.NANOS) {
            return this.duration.get(unit);
        }
        return this.period.get(unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return this.units;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        return temporal.plus(this.period).plus(this.duration);
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        return temporal.minus(this.period).minus(this.duration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Interval)) {
            return false;
        }
        Interval interval = (Interval)o;
        return Objects.equals(this.getPeriod(), interval.getPeriod()) && Objects.equals(this.getDuration(), interval.getDuration());
    }

    public int hashCode() {
        return Objects.hash(this.getPeriod(), this.getDuration());
    }

    public String toString() {
        if (this.period.isZero()) {
            return this.duration.toString();
        }
        if (this.duration.isZero()) {
            return this.period.toString();
        }
        return this.period.toString() + this.duration.toString().substring(1);
    }

    private boolean isCalendarBased() {
        return !this.getPeriod().isZero() || this.getDuration().compareTo(ACCURATE_DURATION_UPPER_BOUND) >= 0;
    }

    public static Interval parse(String text) {
        String sign = "";
        int startOffset = 0;
        if (text.startsWith("-")) {
            startOffset = 1;
            sign = "-";
        } else if (text.startsWith("+")) {
            startOffset = 1;
        }
        int durationOffset = text.indexOf(84);
        if (durationOffset == -1) {
            return new Interval(Period.parse(text), Duration.ZERO);
        }
        if (durationOffset == startOffset + 1) {
            return new Interval(Period.ZERO, Duration.parse(text));
        }
        return new Interval(Period.parse(text.substring(0, durationOffset)), Duration.parse(sign + "P" + text.substring(durationOffset)));
    }
}

