/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.builder;

import io.zeebe.model.bpmn.BpmnModelInstance;
import io.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.zeebe.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.zeebe.model.bpmn.builder.ZeebeVariablesMappingBuilder;
import io.zeebe.model.bpmn.instance.Activity;
import io.zeebe.model.bpmn.instance.BaseElement;
import io.zeebe.model.bpmn.instance.BoundaryEvent;
import io.zeebe.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import io.zeebe.model.bpmn.instance.bpmndi.BpmnShape;
import io.zeebe.model.bpmn.instance.dc.Bounds;
import io.zeebe.model.bpmn.instance.zeebe.ZeebeInput;
import io.zeebe.model.bpmn.instance.zeebe.ZeebeIoMapping;
import io.zeebe.model.bpmn.instance.zeebe.ZeebeOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;

public abstract class AbstractActivityBuilder<B extends AbstractActivityBuilder<B, E>, E extends Activity>
extends AbstractFlowNodeBuilder<B, E>
implements ZeebeVariablesMappingBuilder<B> {
    protected AbstractActivityBuilder(BpmnModelInstance modelInstance, E element, Class<?> selfType) {
        super(modelInstance, element, selfType);
    }

    public BoundaryEventBuilder boundaryEvent() {
        return this.boundaryEvent(null);
    }

    public BoundaryEventBuilder boundaryEvent(String id) {
        BoundaryEvent boundaryEvent = this.createSibling(BoundaryEvent.class, id);
        boundaryEvent.setAttachedTo((Activity)this.element);
        BpmnShape boundaryEventBpmnShape = this.createBpmnShape(boundaryEvent);
        this.setBoundaryEventCoordinates(boundaryEventBpmnShape);
        return boundaryEvent.builder();
    }

    public BoundaryEventBuilder boundaryEvent(String id, Consumer<BoundaryEventBuilder> consumer) {
        BoundaryEventBuilder builder = this.boundaryEvent(id);
        consumer.accept(builder);
        return builder;
    }

    public MultiInstanceLoopCharacteristicsBuilder multiInstance() {
        MultiInstanceLoopCharacteristics miCharacteristics = this.createChild(MultiInstanceLoopCharacteristics.class);
        return miCharacteristics.builder();
    }

    protected double calculateXCoordinate(Bounds boundaryEventBounds) {
        BpmnShape attachedToElement = this.findBpmnShape((BaseElement)this.element);
        double x = 0.0;
        if (attachedToElement != null) {
            Bounds attachedToBounds = attachedToElement.getBounds();
            Collection boundaryEvents = ((Activity)this.element).getParentElement().getChildElementsByType(BoundaryEvent.class);
            ArrayList<BoundaryEvent> attachedBoundaryEvents = new ArrayList<BoundaryEvent>();
            for (BoundaryEvent tmp : boundaryEvents) {
                if (!tmp.getAttachedTo().equals(this.element)) continue;
                attachedBoundaryEvents.add(tmp);
            }
            double attachedToX = attachedToBounds.getX();
            double attachedToWidth = attachedToBounds.getWidth();
            double boundaryWidth = boundaryEventBounds.getWidth();
            switch (attachedBoundaryEvents.size()) {
                case 2: {
                    x = attachedToX + attachedToWidth / 2.0 + boundaryWidth / 2.0;
                    break;
                }
                case 3: {
                    x = attachedToX + attachedToWidth / 2.0 - 1.5 * boundaryWidth;
                    break;
                }
                default: {
                    x = attachedToX + attachedToWidth / 2.0 - boundaryWidth / 2.0;
                }
            }
        }
        return x;
    }

    protected void setBoundaryEventCoordinates(BpmnShape bpmnShape) {
        BpmnShape activity = this.findBpmnShape((BaseElement)this.element);
        Bounds boundaryBounds = bpmnShape.getBounds();
        double x = 0.0;
        double y = 0.0;
        if (activity != null) {
            Bounds activityBounds = activity.getBounds();
            double activityY = activityBounds.getY();
            double activityHeight = activityBounds.getHeight();
            double boundaryHeight = boundaryBounds.getHeight();
            x = this.calculateXCoordinate(boundaryBounds);
            y = activityY + activityHeight - boundaryHeight / 2.0;
        }
        boundaryBounds.setX(x);
        boundaryBounds.setY(y);
    }

    @Override
    public B zeebeInput(String source, String target) {
        ZeebeIoMapping ioMapping = this.getCreateSingleExtensionElement(ZeebeIoMapping.class);
        ZeebeInput input = this.createChild(ioMapping, ZeebeInput.class);
        input.setSource(source);
        input.setTarget(target);
        return (B)((AbstractActivityBuilder)this.myself);
    }

    @Override
    public B zeebeOutput(String source, String target) {
        ZeebeIoMapping ioMapping = this.getCreateSingleExtensionElement(ZeebeIoMapping.class);
        ZeebeOutput input = this.createChild(ioMapping, ZeebeOutput.class);
        input.setSource(source);
        input.setTarget(target);
        return (B)((AbstractActivityBuilder)this.myself);
    }
}

