/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.parsetools.impl;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.Arguments;
import io.vertx.core.parsetools.RecordParser;
import io.vertx.core.streams.ReadStream;
import java.util.Objects;

public class RecordParserImpl
implements RecordParser {
    private Buffer buff;
    private int pos;
    private int start;
    private int delimPos;
    private boolean reset;
    private boolean delimited;
    private byte[] delim;
    private int recordSize;
    private Handler<Buffer> output;
    private int maxRecordSize;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private final ReadStream<Buffer> stream;

    private RecordParserImpl(ReadStream<Buffer> stream, Handler<Buffer> output) {
        this.stream = stream;
        this.output = output;
    }

    @Override
    public void setOutput(Handler<Buffer> output) {
        Objects.requireNonNull(output, "output");
        this.output = output;
    }

    public static Buffer latin1StringToBytes(String str) {
        byte[] bytes = new byte[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            bytes[i] = (byte)(c & 0xFF);
        }
        return Buffer.buffer(bytes);
    }

    public static RecordParser newDelimited(String delim, ReadStream<Buffer> stream, Handler<Buffer> output) {
        return RecordParserImpl.newDelimited(RecordParserImpl.latin1StringToBytes(delim), stream, output);
    }

    public static RecordParser newDelimited(Buffer delim, ReadStream<Buffer> stream, Handler<Buffer> output) {
        RecordParserImpl ls = new RecordParserImpl(stream, output);
        ls.delimitedMode(delim);
        return ls;
    }

    public static RecordParser newFixed(int size, ReadStream<Buffer> stream, Handler<Buffer> output) {
        Arguments.require(size > 0, "Size must be > 0");
        RecordParserImpl ls = new RecordParserImpl(stream, output);
        ls.fixedSizeMode(size);
        return ls;
    }

    @Override
    public void delimitedMode(String delim) {
        this.delimitedMode(RecordParserImpl.latin1StringToBytes(delim));
    }

    @Override
    public void delimitedMode(Buffer delim) {
        Objects.requireNonNull(delim, "delim");
        this.delimited = true;
        this.delim = delim.getBytes();
        this.delimPos = 0;
        this.reset = true;
    }

    @Override
    public void fixedSizeMode(int size) {
        Arguments.require(size > 0, "Size must be > 0");
        this.delimited = false;
        this.recordSize = size;
        this.reset = true;
    }

    @Override
    public RecordParser maxRecordSize(int size) {
        Arguments.require(size > 0, "Size must be > 0");
        this.maxRecordSize = size;
        return this;
    }

    private void handleParsing() {
        int len = this.buff.length();
        do {
            this.reset = false;
            if (this.delimited) {
                this.parseDelimited();
                continue;
            }
            this.parseFixed();
        } while (this.reset);
        if (this.start == len) {
            this.buff = null;
            this.pos = 0;
        } else {
            this.buff = this.buff.getBuffer(this.start, len);
            this.pos = this.buff.length();
        }
        this.start = 0;
    }

    private void parseDelimited() {
        int len = this.buff.length();
        while (this.pos < len && !this.reset) {
            if (this.buff.getByte(this.pos) == this.delim[this.delimPos]) {
                ++this.delimPos;
                if (this.delimPos == this.delim.length) {
                    Buffer ret = this.buff.getBuffer(this.start, this.pos - this.delim.length + 1);
                    this.start = this.pos + 1;
                    this.delimPos = 0;
                    this.output.handle(ret);
                }
            } else if (this.delimPos > 0) {
                this.pos -= this.delimPos;
                this.delimPos = 0;
            }
            ++this.pos;
        }
    }

    private void parseFixed() {
        int len = this.buff.length();
        while (len - this.start >= this.recordSize && !this.reset) {
            int end = this.start + this.recordSize;
            Buffer ret = this.buff.getBuffer(this.start, end);
            this.start = end;
            this.pos = this.start - 1;
            this.output.handle(ret);
        }
    }

    @Override
    public void handle(Buffer buffer) {
        if (this.buff == null) {
            this.buff = buffer;
        } else {
            this.buff.appendBuffer(buffer);
        }
        this.handleParsing();
        if (this.buff != null && this.maxRecordSize > 0 && this.buff.length() > this.maxRecordSize) {
            IllegalStateException ex = new IllegalStateException("The current record is too long");
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(ex);
            } else {
                throw ex;
            }
        }
    }

    private void end() {
        Handler<Void> handler = this.endHandler;
        if (handler != null) {
            handler.handle(null);
        }
    }

    @Override
    public RecordParser exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public RecordParser handler(Handler<Buffer> handler) {
        this.output = handler;
        if (this.stream != null) {
            if (handler != null) {
                this.stream.endHandler((Void v) -> this.end());
                this.stream.exceptionHandler(err -> {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.handle((Throwable)err);
                    }
                });
                this.stream.handler(this);
            } else {
                this.stream.handler(null);
                this.stream.endHandler(null);
                this.stream.exceptionHandler((Handler)null);
            }
        }
        return this;
    }

    @Override
    public RecordParser pause() {
        if (this.stream != null) {
            this.stream.pause();
        }
        return this;
    }

    @Override
    public RecordParser resume() {
        if (this.stream != null) {
            this.stream.resume();
        }
        return this;
    }

    @Override
    public RecordParser endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }
}

