/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.stub;

import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;

public class ServerCalls {
    private ServerCalls() {
    }

    public static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncUnaryCall(UnaryMethod<ReqT, RespT> method) {
        return ServerCalls.asyncUnaryRequestCall(method);
    }

    public static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncServerStreamingCall(ServerStreamingMethod<ReqT, RespT> method) {
        return ServerCalls.asyncUnaryRequestCall(method);
    }

    public static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncClientStreamingCall(ClientStreamingMethod<ReqT, RespT> method) {
        return ServerCalls.asyncStreamingRequestCall(method);
    }

    public static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncBidiStreamingCall(BidiStreamingMethod<ReqT, RespT> method) {
        return ServerCalls.asyncStreamingRequestCall(method);
    }

    private static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncUnaryRequestCall(final UnaryRequestMethod<ReqT, RespT> method) {
        return new ServerCallHandler<ReqT, RespT>(){

            @Override
            public ServerCall.Listener<ReqT> startCall(MethodDescriptor<ReqT, RespT> methodDescriptor, final ServerCall<RespT> call, Metadata headers) {
                final ResponseObserver responseObserver = new ResponseObserver(call);
                call.request(2);
                return new EmptyServerCallListener<ReqT>(){
                    ReqT request;

                    @Override
                    public void onMessage(ReqT request) {
                        if (this.request == null) {
                            this.request = request;
                        } else {
                            call.close(Status.INVALID_ARGUMENT.withDescription("More than one request messages for unary call or server streaming call"), new Metadata());
                        }
                    }

                    @Override
                    public void onHalfClose() {
                        if (this.request != null) {
                            method.invoke(this.request, responseObserver);
                        } else {
                            call.close(Status.INVALID_ARGUMENT.withDescription("Half-closed without a request"), new Metadata());
                        }
                    }

                    @Override
                    public void onCancel() {
                        responseObserver.cancelled = true;
                    }
                };
            }
        };
    }

    private static <ReqT, RespT> ServerCallHandler<ReqT, RespT> asyncStreamingRequestCall(final StreamingRequestMethod<ReqT, RespT> method) {
        return new ServerCallHandler<ReqT, RespT>(){

            @Override
            public ServerCall.Listener<ReqT> startCall(MethodDescriptor<ReqT, RespT> methodDescriptor, final ServerCall<RespT> call, Metadata headers) {
                call.request(1);
                final ResponseObserver responseObserver = new ResponseObserver(call);
                final StreamObserver requestObserver = method.invoke(responseObserver);
                return new EmptyServerCallListener<ReqT>(){
                    boolean halfClosed = false;

                    @Override
                    public void onMessage(ReqT request) {
                        requestObserver.onNext(request);
                        call.request(1);
                    }

                    @Override
                    public void onHalfClose() {
                        this.halfClosed = true;
                        requestObserver.onCompleted();
                    }

                    @Override
                    public void onCancel() {
                        if (!this.halfClosed) {
                            requestObserver.onError(Status.CANCELLED.asException());
                        }
                        responseObserver.cancelled = true;
                    }
                };
            }
        };
    }

    private static class EmptyServerCallListener<ReqT>
    extends ServerCall.Listener<ReqT> {
        private EmptyServerCallListener() {
        }

        @Override
        public void onMessage(ReqT request) {
        }

        @Override
        public void onHalfClose() {
        }

        @Override
        public void onCancel() {
        }

        @Override
        public void onComplete() {
        }
    }

    private static class ResponseObserver<RespT>
    implements StreamObserver<RespT> {
        final ServerCall<RespT> call;
        volatile boolean cancelled;
        private boolean sentHeaders;

        ResponseObserver(ServerCall<RespT> call) {
            this.call = call;
        }

        @Override
        public void onNext(RespT response) {
            if (this.cancelled) {
                throw Status.CANCELLED.asRuntimeException();
            }
            if (!this.sentHeaders) {
                this.call.sendHeaders(new Metadata());
                this.sentHeaders = true;
            }
            this.call.sendMessage(response);
        }

        @Override
        public void onError(Throwable t) {
            this.call.close(Status.fromThrowable(t), new Metadata());
        }

        @Override
        public void onCompleted() {
            if (this.cancelled) {
                throw Status.CANCELLED.asRuntimeException();
            }
            this.call.close(Status.OK, new Metadata());
        }
    }

    private static interface StreamingRequestMethod<ReqT, RespT> {
        public StreamObserver<ReqT> invoke(StreamObserver<RespT> var1);
    }

    private static interface UnaryRequestMethod<ReqT, RespT> {
        public void invoke(ReqT var1, StreamObserver<RespT> var2);
    }

    public static interface BidiStreamingMethod<ReqT, RespT>
    extends StreamingRequestMethod<ReqT, RespT> {
    }

    public static interface ClientStreamingMethod<ReqT, RespT>
    extends StreamingRequestMethod<ReqT, RespT> {
    }

    public static interface ServerStreamingMethod<ReqT, RespT>
    extends UnaryRequestMethod<ReqT, RespT> {
    }

    public static interface UnaryMethod<ReqT, RespT>
    extends UnaryRequestMethod<ReqT, RespT> {
    }
}

