/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.squareup.okhttp.CipherSuite;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.TlsVersion;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.AbstractReferenceCounted;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.okhttp.NegotiationType;
import io.grpc.okhttp.OkHttpClientTransport;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocketFactory;

public final class OkHttpChannelBuilder
extends AbstractManagedChannelImplBuilder<OkHttpChannelBuilder> {
    public static final ConnectionSpec DEFAULT_CONNECTION_SPEC = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).cipherSuites(new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384}).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).supportsTlsExtensions(true).build();
    private static final SharedResourceHolder.Resource<ExecutorService> SHARED_EXECUTOR = new SharedResourceHolder.Resource<ExecutorService>(){

        @Override
        public ExecutorService create() {
            return Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("grpc-okhttp-%d").build());
        }

        @Override
        public void close(ExecutorService executor) {
            executor.shutdown();
        }
    };
    private Executor transportExecutor;
    private final String host;
    private final int port;
    private String authority;
    private SSLSocketFactory sslSocketFactory;
    private ConnectionSpec connectionSpec = DEFAULT_CONNECTION_SPEC;
    private NegotiationType negotiationType = NegotiationType.TLS;
    private int maxMessageSize = 0x6400000;

    public static OkHttpChannelBuilder forAddress(String host, int port) {
        return new OkHttpChannelBuilder(host, port);
    }

    private OkHttpChannelBuilder(String host, int port) {
        this.host = (String)Preconditions.checkNotNull((Object)host);
        this.port = port;
        this.authority = GrpcUtil.authorityFromHostAndPort(host, port);
    }

    public OkHttpChannelBuilder transportExecutor(@Nullable Executor transportExecutor) {
        this.transportExecutor = transportExecutor;
        return this;
    }

    @Deprecated
    public OkHttpChannelBuilder overrideHostForAuthority(String host) {
        this.authority = GrpcUtil.authorityFromHostAndPort(host, this.port);
        return this;
    }

    @Override
    public OkHttpChannelBuilder overrideAuthority(String authority) {
        this.authority = GrpcUtil.checkAuthority(authority);
        return this;
    }

    public OkHttpChannelBuilder negotiationType(NegotiationType type) {
        this.negotiationType = (NegotiationType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        return this;
    }

    public OkHttpChannelBuilder sslSocketFactory(SSLSocketFactory factory) {
        this.sslSocketFactory = factory;
        this.negotiationType(NegotiationType.TLS);
        return this;
    }

    public OkHttpChannelBuilder connectionSpec(ConnectionSpec connectionSpec) {
        this.connectionSpec = connectionSpec;
        return this;
    }

    public OkHttpChannelBuilder maxMessageSize(int maxMessageSize) {
        Preconditions.checkArgument((maxMessageSize >= 0 ? 1 : 0) != 0, (Object)"maxMessageSize must be >= 0");
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    @Override
    public OkHttpChannelBuilder usePlaintext(boolean skipNegotiation) {
        if (!skipNegotiation) {
            throw new IllegalArgumentException("Plaintext negotiation not currently supported");
        }
        this.negotiationType(NegotiationType.PLAINTEXT);
        return this;
    }

    @Override
    protected ClientTransportFactory buildTransportFactory() {
        return new OkHttpTransportFactory(this.host, this.port, this.authority, this.transportExecutor, this.createSocketFactory(), this.connectionSpec, this.maxMessageSize);
    }

    private SSLSocketFactory createSocketFactory() {
        switch (this.negotiationType) {
            case TLS: {
                return this.sslSocketFactory == null ? (SSLSocketFactory)SSLSocketFactory.getDefault() : this.sslSocketFactory;
            }
            case PLAINTEXT: {
                return null;
            }
        }
        throw new RuntimeException("Unknown negotiation type: " + (Object)((Object)this.negotiationType));
    }

    private static class OkHttpTransportFactory
    extends AbstractReferenceCounted
    implements ClientTransportFactory {
        private final String host;
        private final int port;
        private final String authority;
        private final Executor executor;
        private final boolean usingSharedExecutor;
        private final SSLSocketFactory socketFactory;
        private final ConnectionSpec connectionSpec;
        private final int maxMessageSize;

        private OkHttpTransportFactory(String host, int port, String authority, Executor executor, SSLSocketFactory socketFactory, ConnectionSpec connectionSpec, int maxMessageSize) {
            this.host = host;
            this.port = port;
            this.authority = authority;
            this.socketFactory = socketFactory;
            this.connectionSpec = connectionSpec;
            this.maxMessageSize = maxMessageSize;
            this.usingSharedExecutor = executor == null;
            this.executor = this.usingSharedExecutor ? (Executor)SharedResourceHolder.get(SHARED_EXECUTOR) : executor;
        }

        @Override
        public ClientTransport newClientTransport() {
            return new OkHttpClientTransport(this.host, this.port, this.authority, this.executor, this.socketFactory, this.connectionSpec, this.maxMessageSize);
        }

        @Override
        public String authority() {
            return this.authority;
        }

        @Override
        protected void deallocate() {
            if (this.usingSharedExecutor) {
                SharedResourceHolder.release(SHARED_EXECUTOR, (ExecutorService)this.executor);
            }
        }
    }
}

