/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters.java8;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.sql2o.converters.Converter;
import org.sql2o.converters.ConverterException;

public class LocalDateTimeConverter
implements Converter<LocalDateTime> {
    public LocalDateTimeConverter(LocalDateTime localDateTime) {
    }

    public LocalDateTimeConverter() {
        this(LocalDateTime.now());
    }

    @Override
    public LocalDateTime convert(Object val) throws ConverterException {
        if (val == null) {
            return null;
        }
        try {
            Timestamp timestamp = (Timestamp)val;
            return timestamp.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        catch (IllegalArgumentException ex) {
            throw new ConverterException("Error while converting type " + val.getClass().toString() + " to jodatime", ex);
        }
    }

    @Override
    public Object toDatabaseParam(LocalDateTime val) {
        return new Date(val.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }
}

