/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters.java8;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneId;
import org.sql2o.converters.Converter;
import org.sql2o.converters.ConverterException;

public class LocalDateConverter
implements Converter<LocalDate> {
    @Override
    public LocalDate convert(Object val) throws ConverterException {
        if (val == null) {
            return null;
        }
        try {
            return ((Timestamp)val).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        catch (IllegalArgumentException ex) {
            throw new ConverterException("Don't know how to convert from type '" + val.getClass().getName() + "' to type '" + LocalDate.class.getName() + "'", ex);
        }
    }

    @Override
    public Object toDatabaseParam(LocalDate val) {
        return Date.valueOf(val);
    }
}

