/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.sql2o.converters.Converter;
import org.sql2o.converters.ConverterException;
import org.sql2o.converters.UUIDConverter;

public class OracleUUIDConverter
implements Converter<UUID> {
    private final UUIDConverter baseConverter = new UUIDConverter();

    @Override
    public UUID convert(Object val) throws ConverterException {
        if (val instanceof byte[]) {
            ByteBuffer bb = ByteBuffer.wrap((byte[])val);
            long mostSignigcant = bb.getLong();
            long leastSignificant = bb.getLong();
            return new UUID(mostSignigcant, leastSignificant);
        }
        return this.baseConverter.convert(val);
    }

    @Override
    public Object toDatabaseParam(UUID val) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(val.getMostSignificantBits());
        bb.putLong(val.getLeastSignificantBits());
        return bb.array();
    }
}

