/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters;

import io.github.biezhi.anima.annotation.EnumMapping;
import io.github.biezhi.anima.exception.AnimaException;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.sql2o.converters.Converter;
import org.sql2o.converters.ConverterException;
import org.sql2o.converters.EnumConverterFactory;

public class DefaultEnumConverterFactory
implements EnumConverterFactory {
    private static Map<EnumMapping, Field> fieldMap = new HashMap<EnumMapping, Field>();

    private static <E extends Enum> E getEnum(Object target, Class<E> enumType) {
        Field field;
        EnumMapping enumMapping = enumType.getAnnotation(EnumMapping.class);
        if (!fieldMap.containsKey(enumMapping)) {
            try {
                field = enumType.getDeclaredField(enumMapping.value());
                fieldMap.put(enumMapping, field);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        field = fieldMap.get(enumMapping);
        field.setAccessible(true);
        return (E)((Enum)EnumSet.allOf(enumType).stream().filter(e -> DefaultEnumConverterFactory.filterEnumValue(target, field, e)).findFirst().get());
    }

    private static boolean filterEnumValue(Object target, Field field, Object e) {
        try {
            Object o = field.get(e);
            return target.toString().equals(o.toString());
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
            return false;
        }
    }

    @Override
    public <E extends Enum> Converter<E> newConverter(final Class<E> enumType) {
        return new Converter<E>(){

            @Override
            public E convert(Object val) throws ConverterException {
                if (val == null) {
                    return null;
                }
                try {
                    EnumMapping enumMapping = enumType.getAnnotation(EnumMapping.class);
                    if (null != enumMapping) {
                        return DefaultEnumConverterFactory.getEnum(val, enumType);
                    }
                    if (val instanceof String) {
                        return Enum.valueOf(enumType, val.toString());
                    }
                    if (val instanceof Number) {
                        return ((Enum[])enumType.getEnumConstants())[((Number)val).intValue()];
                    }
                }
                catch (Throwable t) {
                    throw new ConverterException("Error converting value '" + val.toString() + "' to " + enumType.getName(), t);
                }
                throw new ConverterException("Cannot convert type '" + val.getClass().getName() + "' to an Enum");
            }

            @Override
            public Object toDatabaseParam(Enum val) {
                EnumMapping enumMapping = val.getClass().getAnnotation(EnumMapping.class);
                if (null != enumMapping) {
                    try {
                        Field field = val.getClass().getDeclaredField(enumMapping.value());
                        field.setAccessible(true);
                        return field.get(val);
                    }
                    catch (Exception e) {
                        throw new AnimaException(e);
                    }
                }
                return val.name();
            }
        };
    }
}

