/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.anima.utils;

import com.blade.reflectasm.MethodAccess;
import io.github.biezhi.anima.Model;
import io.github.biezhi.anima.core.AnimaCache;
import io.github.biezhi.anima.exception.AnimaException;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class AnimaUtils {
    public static final Object[] EMPTY_ARG = new Object[0];
    public static final Object[] NULL_ARG = new Object[]{null};

    public static boolean isNotEmpty(String value) {
        return null != value && !value.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return null != collection && !collection.isEmpty();
    }

    public static boolean isEmpty(String value) {
        return null == value || value.isEmpty();
    }

    public static String toCamelName(String value) {
        String[] partOfNames = value.split("_");
        StringBuilder sb = new StringBuilder(partOfNames[0]);
        for (int i = 1; i < partOfNames.length; ++i) {
            sb.append(partOfNames[i].substring(0, 1).toUpperCase());
            sb.append(partOfNames[i].substring(1));
        }
        return sb.toString();
    }

    public static String toUnderline(String value) {
        StringBuilder result = new StringBuilder();
        if (value != null && value.length() > 0) {
            result.append(value.substring(0, 1).toLowerCase());
            for (int i = 1; i < value.length(); ++i) {
                String s = value.substring(i, i + 1);
                if (s.equals(s.toUpperCase())) {
                    result.append("_");
                    result.append(s.toLowerCase());
                    continue;
                }
                result.append(s);
            }
        }
        return result.toString();
    }

    public static <T extends Model> List<Object> toColumnValues(T model, boolean allowNull) {
        ArrayList<Object> columnValueList = new ArrayList<Object>();
        for (Field field : AnimaCache.computeModelFields(model.getClass())) {
            try {
                Object value = AnimaUtils.invokeMethod(model, AnimaCache.getGetterName(field.getName()), EMPTY_ARG);
                if (null == value) {
                    if (!allowNull) continue;
                    columnValueList.add(null);
                    continue;
                }
                columnValueList.add(value);
            }
            catch (IllegalArgumentException e) {
                throw new AnimaException("illegal argument or Access:", e);
            }
        }
        return columnValueList;
    }

    public static <T extends Model> String buildColumns(List<String> excludedColumns, Class<T> modelClass) {
        StringBuilder sql = new StringBuilder();
        for (Field field : AnimaCache.computeModelFields(modelClass)) {
            String columnName = AnimaCache.getColumnName(field);
            if (AnimaCache.isIgnore(field) || excludedColumns.contains(columnName)) continue;
            sql.append(columnName).append(',');
        }
        if (sql.length() > 0) {
            return sql.substring(0, sql.length() - 1);
        }
        return "*";
    }

    public static Object invokeMethod(Object target, String methodName, Object[] args) {
        MethodAccess methodAccess = AnimaCache.METHOD_ACCESS_MAP.computeIfAbsent(target.getClass(), type -> {
            List<Method> methods = Arrays.asList(type.getDeclaredMethods());
            return MethodAccess.get((Class)type, methods);
        });
        return methodAccess.invokeWithCache(target, methodName, args);
    }

    public static String getLambdaColumnName(Serializable lambda) {
        Class<?> cl = lambda.getClass();
        if (cl != null) {
            try {
                Method m = cl.getDeclaredMethod("writeReplace", new Class[0]);
                m.setAccessible(true);
                Object replacement = m.invoke((Object)lambda, new Object[0]);
                if (replacement instanceof SerializedLambda) {
                    SerializedLambda serializedLambda = (SerializedLambda)replacement;
                    return AnimaCache.getLambdaColumnName(serializedLambda);
                }
            }
            catch (Exception e) {
                throw new AnimaException("get lambda column name fail", e);
            }
        }
        return null;
    }

    public static String getLambdaFieldName(Serializable lambda) {
        Class<?> cl = lambda.getClass();
        if (cl != null) {
            try {
                Method m = cl.getDeclaredMethod("writeReplace", new Class[0]);
                m.setAccessible(true);
                Object replacement = m.invoke((Object)lambda, new Object[0]);
                if (replacement instanceof SerializedLambda) {
                    SerializedLambda serializedLambda = (SerializedLambda)replacement;
                    return AnimaCache.getLambdaFieldName(serializedLambda);
                }
            }
            catch (Exception e) {
                throw new AnimaException("get lambda column name fail", e);
            }
        }
        return null;
    }

    public static String methodToFieldName(String methodName) {
        return AnimaUtils.capitalize(methodName.replace("get", ""));
    }

    public static String capitalize(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1, input.length());
    }

    public static <S extends Model> Object getAndRemovePrimaryKey(S model) {
        String fieldName = AnimaCache.getPKField(model.getClass());
        Object value = AnimaUtils.invokeMethod(model, AnimaCache.getGetterName(fieldName), EMPTY_ARG);
        if (null != value) {
            AnimaUtils.invokeMethod(model, AnimaCache.getSetterName(fieldName), NULL_ARG);
        }
        return value;
    }

    public static <T> T[] toArray(List<T> list) {
        Object[] toR = (Object[])Array.newInstance(list.get(0).getClass(), list.size());
        for (int i = 0; i < list.size(); ++i) {
            toR[i] = list.get(i);
        }
        return toR;
    }

    private AnimaUtils() {
    }
}

