/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.anima.dialect;

import io.github.biezhi.anima.core.AnimaCache;
import io.github.biezhi.anima.core.SQLParams;
import io.github.biezhi.anima.exception.AnimaException;
import io.github.biezhi.anima.utils.AnimaUtils;
import java.lang.reflect.Field;

public interface Dialect {
    default public String select(SQLParams sqlParams) {
        StringBuilder sql = new StringBuilder();
        if (AnimaUtils.isNotEmpty(sqlParams.getCustomSQL())) {
            sql.append(sqlParams.getCustomSQL());
        } else {
            sql.append("SELECT");
            if (AnimaUtils.isNotEmpty(sqlParams.getSelectColumns())) {
                sql.append(' ').append(sqlParams.getSelectColumns()).append(' ');
            } else if (AnimaUtils.isNotEmpty(sqlParams.getExcludedColumns())) {
                sql.append(' ').append(AnimaUtils.buildColumns(sqlParams.getExcludedColumns(), sqlParams.getModelClass())).append(' ');
            } else {
                sql.append(" * ");
            }
            sql.append("FROM ").append(sqlParams.getTableName());
            if (sqlParams.getConditionSQL().length() > 0) {
                sql.append(" WHERE ").append(sqlParams.getConditionSQL().substring(5));
            }
        }
        if (AnimaUtils.isNotEmpty(sqlParams.getOrderBy())) {
            sql.append(" ORDER BY").append(sqlParams.getOrderBy());
        }
        if (sqlParams.isSQLLimit()) {
            sql.append(" LIMIT ?");
        }
        return sql.toString();
    }

    default public String count(SQLParams sqlParams) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT COUNT(*) FROM ").append(sqlParams.getTableName());
        if (sqlParams.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(sqlParams.getConditionSQL().substring(5));
        }
        return sql.toString();
    }

    default public String insert(SQLParams sqlParams) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(sqlParams.getTableName());
        StringBuilder columnNames = new StringBuilder();
        StringBuilder placeholder = new StringBuilder();
        for (Field field : AnimaCache.computeModelFields(sqlParams.getModelClass())) {
            columnNames.append(",").append(AnimaCache.getColumnName(field));
            placeholder.append(",?");
        }
        sql.append("(").append(columnNames.substring(1)).append(")").append(" VALUES (").append(placeholder.substring(1)).append(")");
        return sql.toString();
    }

    default public String update(SQLParams sqlParams) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(sqlParams.getTableName()).append(" SET ");
        StringBuilder setSQL = new StringBuilder();
        if (null != sqlParams.getUpdateColumns() && !sqlParams.getUpdateColumns().isEmpty()) {
            sqlParams.getUpdateColumns().forEach((key, value) -> setSQL.append((String)key).append(" = ?, "));
        } else if (null != sqlParams.getModel()) {
            for (Field field : AnimaCache.computeModelFields(sqlParams.getModelClass())) {
                try {
                    Object value2 = AnimaUtils.invokeMethod(sqlParams.getModel(), AnimaCache.getGetterName(field.getName()), AnimaUtils.EMPTY_ARG);
                    if (null == value2) continue;
                    setSQL.append(AnimaCache.getColumnName(field)).append(" = ?, ");
                }
                catch (IllegalArgumentException e) {
                    throw new AnimaException("illegal argument or Access:", e);
                }
            }
        }
        sql.append(setSQL.substring(0, setSQL.length() - 2));
        if (sqlParams.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(sqlParams.getConditionSQL().substring(5));
        }
        return sql.toString();
    }

    default public String delete(SQLParams sqlParams) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(sqlParams.getTableName());
        if (sqlParams.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(sqlParams.getConditionSQL().substring(5));
        } else if (null != sqlParams.getModel()) {
            StringBuilder columnNames = new StringBuilder();
            for (Field field : AnimaCache.computeModelFields(sqlParams.getModelClass())) {
                try {
                    Object value = AnimaUtils.invokeMethod(sqlParams.getModel(), AnimaCache.getGetterName(field.getName()), AnimaUtils.EMPTY_ARG);
                    if (null == value) continue;
                    columnNames.append(AnimaCache.getColumnName(field)).append(" = ? and ");
                }
                catch (IllegalArgumentException e) {
                    throw new AnimaException("illegal argument or Access:", e);
                }
            }
            if (columnNames.length() > 0) {
                sql.append(" WHERE ").append(columnNames.substring(0, columnNames.length() - 5));
            }
        }
        return sql.toString();
    }

    public String paginate(SQLParams var1);
}

