/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.anima.core;

import io.github.biezhi.anima.Model;
import io.github.biezhi.anima.core.functions.TypeFunction;
import io.github.biezhi.anima.enums.OrderBy;
import io.github.biezhi.anima.utils.AnimaUtils;

public class JoinParam {
    private Class<? extends Model> joinModel;
    private String onLeft;
    private String onRight;
    private String fieldName;
    private String orderBy;

    public JoinParam(Class<? extends Model> joinModel) {
        this.joinModel = joinModel;
    }

    public <T, R> JoinParam as(TypeFunction<T, R> function) {
        String fieldName = AnimaUtils.getLambdaColumnName(function);
        this.setFieldName(fieldName);
        return this;
    }

    public <T, S extends Model, R> JoinParam on(TypeFunction<T, R> left, TypeFunction<S, R> right) {
        String onLeft = AnimaUtils.getLambdaFieldName(left);
        String onRight = AnimaUtils.getLambdaColumnName(right);
        this.setOnLeft(onLeft);
        this.setOnRight(onRight);
        return this;
    }

    public <S extends Model, R> JoinParam order(TypeFunction<S, R> rightField, OrderBy orderBy) {
        String columnName = AnimaUtils.getLambdaColumnName(rightField);
        this.orderBy = columnName + " " + orderBy.name();
        return this;
    }

    public JoinParam order(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public Class<? extends Model> getJoinModel() {
        return this.joinModel;
    }

    public String getOnLeft() {
        return this.onLeft;
    }

    public String getOnRight() {
        return this.onRight;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setJoinModel(Class<? extends Model> joinModel) {
        this.joinModel = joinModel;
    }

    public void setOnLeft(String onLeft) {
        this.onLeft = onLeft;
    }

    public void setOnRight(String onRight) {
        this.onRight = onRight;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoinParam)) {
            return false;
        }
        JoinParam other = (JoinParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<? extends Model> this$joinModel = this.getJoinModel();
        Class<? extends Model> other$joinModel = other.getJoinModel();
        if (this$joinModel == null ? other$joinModel != null : !this$joinModel.equals(other$joinModel)) {
            return false;
        }
        String this$onLeft = this.getOnLeft();
        String other$onLeft = other.getOnLeft();
        if (this$onLeft == null ? other$onLeft != null : !this$onLeft.equals(other$onLeft)) {
            return false;
        }
        String this$onRight = this.getOnRight();
        String other$onRight = other.getOnRight();
        if (this$onRight == null ? other$onRight != null : !this$onRight.equals(other$onRight)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$orderBy = this.getOrderBy();
        String other$orderBy = other.getOrderBy();
        return !(this$orderBy == null ? other$orderBy != null : !this$orderBy.equals(other$orderBy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JoinParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<? extends Model> $joinModel = this.getJoinModel();
        result = result * 59 + ($joinModel == null ? 43 : $joinModel.hashCode());
        String $onLeft = this.getOnLeft();
        result = result * 59 + ($onLeft == null ? 43 : $onLeft.hashCode());
        String $onRight = this.getOnRight();
        result = result * 59 + ($onRight == null ? 43 : $onRight.hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $orderBy = this.getOrderBy();
        result = result * 59 + ($orderBy == null ? 43 : $orderBy.hashCode());
        return result;
    }

    public String toString() {
        return "JoinParam(joinModel=" + this.getJoinModel() + ", onLeft=" + this.getOnLeft() + ", onRight=" + this.getOnRight() + ", fieldName=" + this.getFieldName() + ", orderBy=" + this.getOrderBy() + ")";
    }
}

