/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.anima.core;

import io.github.biezhi.anima.Anima;
import io.github.biezhi.anima.Model;
import io.github.biezhi.anima.core.AnimaCache;
import io.github.biezhi.anima.core.JoinParam;
import io.github.biezhi.anima.core.ResultKey;
import io.github.biezhi.anima.core.SQLParams;
import io.github.biezhi.anima.core.functions.TypeFunction;
import io.github.biezhi.anima.enums.DMLType;
import io.github.biezhi.anima.enums.ErrorCode;
import io.github.biezhi.anima.enums.OrderBy;
import io.github.biezhi.anima.exception.AnimaException;
import io.github.biezhi.anima.page.Page;
import io.github.biezhi.anima.page.PageRow;
import io.github.biezhi.anima.utils.AnimaUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sql2o.Connection;
import org.sql2o.Sql2o;

public class AnimaQuery<T extends Model> {
    private static final Logger log = LoggerFactory.getLogger(AnimaQuery.class);
    private static Sql2o sql2o;
    private Class<T> modelClass;
    private static ThreadLocal<Connection> connectionThreadLocal;
    private StringBuilder conditionSQL = new StringBuilder();
    private StringBuilder orderBySQL = new StringBuilder();
    private List<String> excludedColumns = new ArrayList<String>(8);
    private List<Object> paramValues = new ArrayList<Object>(8);
    private Map<String, Object> updateColumns = new LinkedHashMap<String, Object>(8);
    private boolean isSQLLimit;
    private boolean useSQL;
    private String selectColumns;
    private String primaryKeyColumn;
    private String tableName;
    private DMLType dmlType;
    private List<JoinParam> joinParams = new ArrayList<JoinParam>();

    public AnimaQuery(DMLType dmlType) {
        this.dmlType = dmlType;
    }

    public AnimaQuery(Class<T> modelClass) {
        this.parse(modelClass);
    }

    public AnimaQuery<T> parse(Class<T> modelClass) {
        this.modelClass = modelClass;
        this.tableName = AnimaCache.getTableName(modelClass);
        this.primaryKeyColumn = AnimaCache.getPKColumn(modelClass);
        return this;
    }

    public AnimaQuery<T> exclude(String ... columnNames) {
        Collections.addAll(this.excludedColumns, columnNames);
        return this;
    }

    public <R> AnimaQuery<T> exclude(TypeFunction<T, R> ... functions) {
        String[] columnNames = Arrays.stream(functions).map(AnimaUtils::getLambdaColumnName).collect(Collectors.toList()).toArray(new String[functions.length]);
        return this.exclude(columnNames);
    }

    public AnimaQuery<T> select(String columns) {
        if (null != this.selectColumns) {
            throw new AnimaException("Select method can only be called once.");
        }
        this.selectColumns = columns;
        return this;
    }

    public AnimaQuery<T> where(String statement) {
        this.conditionSQL.append(" AND ").append(statement);
        return this;
    }

    public AnimaQuery<T> where(String statement, Object value) {
        this.conditionSQL.append(" AND ").append(statement);
        if (!statement.contains("?")) {
            this.conditionSQL.append(" = ?");
        }
        this.paramValues.add(value);
        return this;
    }

    public <R> AnimaQuery<T> where(TypeFunction<T, R> function) {
        String columnName = AnimaUtils.getLambdaColumnName(function);
        this.conditionSQL.append(" AND ").append(columnName);
        return this;
    }

    public <S extends Model, R> AnimaQuery<T> where(TypeFunction<S, R> function, Object value) {
        String columnName = AnimaUtils.getLambdaColumnName(function);
        this.conditionSQL.append(" AND ").append(columnName).append(" = ?");
        this.paramValues.add(value);
        return this;
    }

    public AnimaQuery<T> where(T model) {
        Field[] declaredFields;
        for (Field declaredField : declaredFields = model.getClass().getDeclaredFields()) {
            Object value = AnimaUtils.invokeMethod(model, AnimaCache.getGetterName(declaredField.getName()), AnimaUtils.EMPTY_ARG);
            if (null == value || declaredField.getType().equals(String.class) && AnimaUtils.isEmpty(value.toString())) continue;
            String columnName = AnimaCache.getColumnName(declaredField);
            this.where(columnName, value);
        }
        return this;
    }

    public AnimaQuery<T> eq(Object value) {
        this.conditionSQL.append(" = ?");
        this.paramValues.add(value);
        return this;
    }

    public AnimaQuery<T> notNull() {
        this.conditionSQL.append(" IS NOT NULL");
        return this;
    }

    public AnimaQuery<T> and(String statement, Object value) {
        return this.where(statement, value);
    }

    public <R> AnimaQuery<T> and(TypeFunction<T, R> function) {
        return this.where((T)function);
    }

    public <R> AnimaQuery<T> and(TypeFunction<T, R> function, Object value) {
        return this.where(function, value);
    }

    public AnimaQuery<T> or(String statement, Object value) {
        this.conditionSQL.append(" OR (").append(statement);
        if (!statement.contains("?")) {
            this.conditionSQL.append(" = ?");
        }
        this.conditionSQL.append(')');
        this.paramValues.add(value);
        return this;
    }

    public AnimaQuery<T> notEq(String columnName, Object value) {
        this.conditionSQL.append(" AND ").append(columnName).append(" != ?");
        this.paramValues.add(value);
        return this;
    }

    public <R> AnimaQuery<T> notEq(TypeFunction<T, R> function, Object value) {
        String columnName = AnimaUtils.getLambdaColumnName(function);
        return this.notEq(columnName, value);
    }

    public AnimaQuery<T> notEq(Object value) {
        this.conditionSQL.append(" != ?");
        this.paramValues.add(value);
        return this;
    }

    public AnimaQuery<T> notEmpty(String columnName) {
        this.conditionSQL.append(" AND ").append(columnName).append(" != ''");
        return this;
    }

    public <R> AnimaQuery<T> notEmpty(TypeFunction<T, R> function) {
        String columnName = AnimaUtils.getLambdaColumnName(function);
        return this.notEmpty(columnName);
    }

    public AnimaQuery<T> notEmpty() {
        this.conditionSQL.append(" != ''");
        return this;
    }

    public AnimaQuery<T> notNull(String columnName) {
        this.conditionSQL.append(" AND ").append(columnName).append(" IS NOT NULL");
        return this;
    }

    public AnimaQuery<T> like(String columnName, Object value) {
        this.conditionSQL.append(" AND ").append(columnName).append(" LIKE ?");
        this.paramValues.add(value);
        return this;
    }

    public <R> AnimaQuery<T> like(TypeFunction<T, R> function, Object value) {
        String columnName = AnimaUtils.getLambdaColumnName(function);
        return this.like(columnName, value);
    }

    public AnimaQuery<T> like(Object value) {
        this.conditionSQL.append(" LIKE ?");
        this.paramValues.add(value);
        return this;
    }

    public AnimaQuery<T> between(String columnName, Object a, Object b) {
        this.conditionSQL.append(" AND ").append(columnName).append(" BETWEEN ? and ?");
        this.paramValues.add(a);
        this.paramValues.add(b);
        return this;
    }

    public <R> AnimaQuery<T> between(TypeFunction<T, R> function, Object a, Object b) {
        String columnName = AnimaUtils.getLambdaColumnName(function);
        return this.between(columnName, a, b);
    }

    public AnimaQuery<T> between(Object a, Object b) {
        this.conditionSQL.append(" BETWEEN ? and ?");
        this.paramValues.add(a);
        this.paramValues.add(b);
        return this;
    }

    public AnimaQuery<T> gt(String columnName, Object value) {
        this.conditionSQL.append(" AND ").append(columnName).append(" > ?");
        this.paramValues.add(value);
        return this;
    }

    public <R> AnimaQuery<T> gt(TypeFunction<T, R> function, Object value) {
        String columnName = AnimaUtils.getLambdaColumnName(function);
        return this.gt(columnName, value);
    }

    public AnimaQuery<T> gt(Object value) {
        this.conditionSQL.append(" > ?");
        this.paramValues.add(value);
        return this;
    }

    public AnimaQuery<T> gte(Object value) {
        this.conditionSQL.append(" >= ?");
        this.paramValues.add(value);
        return this;
    }

    public <S extends Model, R> AnimaQuery<T> gte(TypeFunction<S, R> function, Object value) {
        String columnName = AnimaUtils.getLambdaColumnName(function);
        return this.gte(columnName, value);
    }

    public AnimaQuery<T> lt(Object value) {
        this.conditionSQL.append(" < ?");
        this.paramValues.add(value);
        return this;
    }

    public <S extends Model, R> AnimaQuery<T> lt(TypeFunction<S, R> function, Object value) {
        String columnName = AnimaUtils.getLambdaColumnName(function);
        return this.lt(columnName, value);
    }

    public AnimaQuery<T> lte(Object value) {
        this.conditionSQL.append(" <= ?");
        this.paramValues.add(value);
        return this;
    }

    public <S extends Model, R> AnimaQuery<T> lte(TypeFunction<S, R> function, Object value) {
        String columnName = AnimaUtils.getLambdaColumnName(function);
        return this.lte(columnName, value);
    }

    public AnimaQuery<T> gte(String column, Object value) {
        this.conditionSQL.append(" AND ").append(column).append(" >= ?");
        this.paramValues.add(value);
        return this;
    }

    public AnimaQuery<T> lt(String column, Object value) {
        this.conditionSQL.append(" AND ").append(column).append(" < ?");
        this.paramValues.add(value);
        return this;
    }

    public AnimaQuery<T> lte(String column, Object value) {
        this.conditionSQL.append(" AND ").append(column).append(" <= ?");
        this.paramValues.add(value);
        return this;
    }

    public AnimaQuery<T> in(String column, Object ... args) {
        if (null == args || args.length == 0) {
            log.warn("Column: {}, query params is empty.");
            return this;
        }
        this.conditionSQL.append(" AND ").append(column).append(" IN (");
        this.setArguments(args);
        this.conditionSQL.append(")");
        return this;
    }

    public AnimaQuery<T> in(Object ... args) {
        if (null == args || args.length == 0) {
            log.warn("Column: {}, query params is empty.");
            return this;
        }
        this.conditionSQL.append(" IN (");
        this.setArguments(args);
        this.conditionSQL.append(")");
        return this;
    }

    public <S> AnimaQuery<T> in(List<S> list) {
        return this.in(list.toArray());
    }

    public <S> AnimaQuery<T> in(String column, List<S> args) {
        return this.in(column, args.toArray());
    }

    public <R> AnimaQuery<T> in(TypeFunction<T, R> function, Object ... values) {
        String columnName = AnimaUtils.getLambdaColumnName(function);
        return this.in(columnName, values);
    }

    public <S, R> AnimaQuery<T> in(TypeFunction<T, R> function, List<S> values) {
        String columnName = AnimaUtils.getLambdaColumnName(function);
        return this.in(columnName, values);
    }

    public AnimaQuery<T> order(String order) {
        if (this.orderBySQL.length() > 0) {
            this.orderBySQL.append(',');
        }
        this.orderBySQL.append(' ').append(order);
        return this;
    }

    public AnimaQuery<T> order(String columnName, OrderBy orderBy) {
        if (this.orderBySQL.length() > 0) {
            this.orderBySQL.append(',');
        }
        this.orderBySQL.append(' ').append(columnName).append(' ').append(orderBy.toString());
        return this;
    }

    public <R> AnimaQuery<T> order(TypeFunction<T, R> function, OrderBy orderBy) {
        String columnName = AnimaUtils.getLambdaColumnName(function);
        return this.order(columnName, orderBy);
    }

    public T byId(Object id) {
        this.beforeCheck();
        this.where(this.primaryKeyColumn, id);
        String sql = this.buildSelectSQL(false);
        Model model = (Model)this.queryOne(this.modelClass, sql, this.paramValues);
        if (null != model) {
            this.setJoin((T)Collections.singletonList(model));
        }
        return (T)model;
    }

    public List<T> byIds(Object ... ids) {
        this.in(this.primaryKeyColumn, ids);
        return this.all();
    }

    public T one() {
        this.beforeCheck();
        String sql = this.buildSelectSQL(true);
        Model model = (Model)this.queryOne(this.modelClass, sql, this.paramValues);
        if (null != model && null != this.joinParams) {
            this.setJoin((T)Collections.singletonList(model));
        }
        return (T)model;
    }

    public List<T> all() {
        this.beforeCheck();
        String sql = this.buildSelectSQL(true);
        List<T> models = this.queryList(this.modelClass, sql, this.paramValues);
        this.setJoin((T)models);
        return models;
    }

    public List<Map<String, Object>> maps() {
        this.beforeCheck();
        String sql = this.buildSelectSQL(true);
        return this.queryListMap(sql, this.paramValues);
    }

    public Stream<T> stream() {
        List<T> all = this.all();
        if (null == all || all.isEmpty()) {
            return Stream.empty();
        }
        return all.stream();
    }

    public Stream<T> parallel() {
        return (Stream)this.stream().parallel();
    }

    public <R> Stream<R> map(Function<T, R> function) {
        return this.stream().map(function);
    }

    public Stream<T> filter(Predicate<T> predicate) {
        return this.stream().filter(predicate);
    }

    public List<T> limit(int limit) {
        if (Anima.me().isUseSQLLimit()) {
            this.isSQLLimit = true;
            this.paramValues.add(limit);
            return this.all();
        }
        List<T> all = this.all();
        if (all.size() > limit) {
            return all.stream().limit(limit).collect(Collectors.toList());
        }
        return all;
    }

    public Page<T> page(int page, int limit) {
        return this.page(new PageRow(page, limit));
    }

    public Page<T> page(String sql, PageRow pageRow) {
        return this.page(sql, this.paramValues, pageRow);
    }

    public Page<T> page(String sql, List<Object> paramValues, PageRow pageRow) {
        return this.page(sql, paramValues.toArray(), pageRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page<T> page(String sql, Object[] params, PageRow pageRow) {
        this.beforeCheck();
        Connection conn = this.getConn();
        try {
            String countSql = this.useSQL ? "SELECT COUNT(*) FROM (" + sql + ") tmp" : this.buildCountSQL(sql);
            long count = conn.createQuery(countSql).withParams(params).executeAndFetchFirst(Long.class);
            Page<T> pageBean = new Page<T>(count, pageRow.getPageNum(), pageRow.getPageSize());
            if (count > 0L) {
                String pageSQL = this.buildPageSQL(sql, pageRow);
                List<T> list = conn.createQuery(pageSQL).withParams(params).setAutoDeriveColumnNames(true).throwOnMappingFailure(false).executeAndFetch(this.modelClass);
                this.setJoin((T)list);
                pageBean.setRows(list);
            }
            Page<T> page = pageBean;
            return page;
        }
        finally {
            this.closeConn(conn);
            this.clean(null);
        }
    }

    private String buildCountSQL(String sql) {
        return "SELECT COUNT(*) " + sql.substring(sql.indexOf("FROM"));
    }

    public Page<T> page(PageRow pageRow) {
        String sql = this.buildSelectSQL(false);
        return this.page(sql, pageRow);
    }

    public long count() {
        this.beforeCheck();
        String sql = this.buildCountSQL();
        return this.queryOne(Long.class, sql, this.paramValues);
    }

    public AnimaQuery<T> set(String column, Object value) {
        this.updateColumns.put(column, value);
        return this;
    }

    public <S extends Model, R> AnimaQuery<T> set(TypeFunction<S, R> function, Object value) {
        return this.set(AnimaUtils.getLambdaColumnName(function), value);
    }

    public AnimaQuery<T> join(JoinParam joinParam) {
        if (null == joinParam) {
            throw new AnimaException("Join param not null");
        }
        if (null == joinParam.getJoinModel()) {
            throw new AnimaException("Join param [model] not null");
        }
        if (AnimaUtils.isEmpty(joinParam.getFieldName())) {
            throw new AnimaException("Join param [as] not empty");
        }
        if (AnimaUtils.isEmpty(joinParam.getOnLeft())) {
            throw new AnimaException("Join param [onLeft] not empty");
        }
        if (AnimaUtils.isEmpty(joinParam.getOnRight())) {
            throw new AnimaException("Join param [onRight] not empty");
        }
        this.joinParams.add(joinParam);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> S queryOne(Class<S> type, String sql, Object[] params) {
        Connection conn = this.getConn();
        try {
            S s = conn.createQuery(sql).withParams(params).setAutoDeriveColumnNames(true).throwOnMappingFailure(false).executeAndFetchFirst(type);
            return s;
        }
        finally {
            this.closeConn(conn);
            this.clean(null);
        }
    }

    public <S> S queryOne(Class<S> type, String sql, List<Object> params) {
        List<S> list;
        if (Anima.me().isUseSQLLimit()) {
            sql = sql + " LIMIT 1";
        }
        return AnimaUtils.isNotEmpty(list = this.queryList(type, sql, params)) ? (S)list.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> List<S> queryList(Class<S> type, String sql, Object[] params) {
        Connection conn = this.getConn();
        try {
            List<S> list = conn.createQuery(sql).withParams(params).setColumnMappings(AnimaCache.computeModelColumnMappings(type)).throwOnMappingFailure(false).executeAndFetch(type);
            return list;
        }
        finally {
            this.closeConn(conn);
            this.clean(null);
        }
    }

    public <S> List<S> queryList(Class<S> type, String sql, List<Object> params) {
        return this.queryList(type, sql, params.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> queryListMap(String sql, Object[] params) {
        Connection conn = this.getConn();
        try {
            List<Map<String, Object>> list = conn.createQuery(sql).withParams(params).setAutoDeriveColumnNames(true).throwOnMappingFailure(false).executeAndFetchTable().asList();
            return list;
        }
        finally {
            this.closeConn(conn);
            this.clean(null);
        }
    }

    public List<Map<String, Object>> queryListMap(String sql, List<Object> params) {
        return this.queryListMap(sql, params.toArray());
    }

    public int execute() {
        switch (this.dmlType) {
            case UPDATE: {
                return this.update();
            }
            case DELETE: {
                return this.delete();
            }
        }
        throw new AnimaException("Please check if your use is correct.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String sql, Object ... params) {
        Connection conn = this.getConn();
        try {
            int n = conn.createQuery(sql).withParams(params).executeUpdate().getResult();
            return n;
        }
        finally {
            this.closeConn(conn);
            this.clean(conn);
        }
    }

    public int execute(String sql, List<Object> params) {
        return this.execute(sql, params.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends Model> ResultKey save(S model) {
        String sql = this.buildInsertSQL(model);
        List<Object> columnValueList = AnimaUtils.toColumnValues(model, true);
        Connection conn = this.getConn();
        try {
            ResultKey resultKey = new ResultKey(conn.createQuery(sql).withParams(columnValueList).executeUpdate().getKey());
            return resultKey;
        }
        finally {
            this.closeConn(conn);
            this.clean(conn);
        }
    }

    public int delete() {
        String sql = this.buildDeleteSQL(null);
        return this.execute(sql, this.paramValues);
    }

    public <S extends Serializable> int deleteById(S id) {
        this.where(this.primaryKeyColumn, id);
        return this.delete();
    }

    public <S extends Model> int deleteByModel(S model) {
        this.beforeCheck();
        String sql = this.buildDeleteSQL(model);
        List<Object> columnValueList = AnimaUtils.toColumnValues(model, false);
        return this.execute(sql, columnValueList);
    }

    public int update() {
        this.beforeCheck();
        String sql = this.buildUpdateSQL(null, this.updateColumns);
        ArrayList<Object> columnValueList = new ArrayList<Object>();
        this.updateColumns.forEach((key, value) -> columnValueList.add(value));
        columnValueList.addAll(this.paramValues);
        return this.execute(sql, columnValueList);
    }

    public int updateById(Serializable id) {
        this.where(this.primaryKeyColumn, (Object)id);
        return this.update();
    }

    public <S extends Model> int updateById(S model, Serializable id) {
        this.where(this.primaryKeyColumn, (Object)id);
        String sql = this.buildUpdateSQL(model, null);
        List<Object> columnValueList = AnimaUtils.toColumnValues(model, false);
        columnValueList.add(id);
        return this.execute(sql, columnValueList);
    }

    public <S extends Model> int updateByModel(S model) {
        this.beforeCheck();
        Object primaryKey = AnimaUtils.getAndRemovePrimaryKey(model);
        StringBuilder sql = new StringBuilder(this.buildUpdateSQL(model, null));
        List<Object> columnValueList = AnimaUtils.toColumnValues(model, false);
        if (null != primaryKey) {
            sql.append(" WHERE ").append(this.primaryKeyColumn).append(" = ?");
            columnValueList.add(primaryKey);
        }
        return this.execute(sql.toString(), columnValueList);
    }

    private void setArguments(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (i == args.length - 1) {
                this.conditionSQL.append("?");
            } else {
                this.conditionSQL.append("?, ");
            }
            this.paramValues.add(args[i]);
        }
    }

    private String buildSelectSQL(boolean addOrderBy) {
        SQLParams sqlParams = SQLParams.builder().modelClass(this.modelClass).selectColumns(this.selectColumns).tableName(this.tableName).pkName(this.primaryKeyColumn).conditionSQL(this.conditionSQL).excludedColumns(this.excludedColumns).isSQLLimit(this.isSQLLimit).build();
        if (addOrderBy) {
            sqlParams.setOrderBy(this.orderBySQL.toString());
        }
        return Anima.me().getDialect().select(sqlParams);
    }

    private String buildCountSQL() {
        SQLParams sqlParams = SQLParams.builder().modelClass(this.modelClass).tableName(this.tableName).pkName(this.primaryKeyColumn).conditionSQL(this.conditionSQL).build();
        return Anima.me().getDialect().count(sqlParams);
    }

    private String buildPageSQL(String sql, PageRow pageRow) {
        SQLParams sqlParams = SQLParams.builder().modelClass(this.modelClass).selectColumns(this.selectColumns).tableName(this.tableName).pkName(this.primaryKeyColumn).conditionSQL(this.conditionSQL).excludedColumns(this.excludedColumns).customSQL(sql).orderBy(this.orderBySQL.toString()).pageRow(pageRow).build();
        return Anima.me().getDialect().paginate(sqlParams);
    }

    private <S extends Model> String buildInsertSQL(S model) {
        SQLParams sqlParams = SQLParams.builder().model(model).modelClass(this.modelClass).tableName(this.tableName).pkName(this.primaryKeyColumn).build();
        return Anima.me().getDialect().insert(sqlParams);
    }

    private <S extends Model> String buildUpdateSQL(S model, Map<String, Object> updateColumns) {
        SQLParams sqlParams = SQLParams.builder().model(model).modelClass(this.modelClass).tableName(this.tableName).pkName(this.primaryKeyColumn).updateColumns(updateColumns).conditionSQL(this.conditionSQL).build();
        return Anima.me().getDialect().update(sqlParams);
    }

    private <S extends Model> String buildDeleteSQL(S model) {
        SQLParams sqlParams = SQLParams.builder().model(model).modelClass(this.modelClass).tableName(this.tableName).pkName(this.primaryKeyColumn).conditionSQL(this.conditionSQL).build();
        return Anima.me().getDialect().delete(sqlParams);
    }

    public AnimaQuery<T> useSQL() {
        this.useSQL = true;
        return this;
    }

    private void beforeCheck() {
        if (null == this.modelClass) {
            throw new AnimaException(ErrorCode.FROM_NOT_NULL);
        }
    }

    private Connection getConn() {
        Connection connection = connectionThreadLocal.get();
        if (null == connection) {
            return this.getSql2o().open();
        }
        return connection;
    }

    public static void beginTransaction() {
        if (null == connectionThreadLocal.get()) {
            Connection connection = AnimaQuery.getSql2o().beginTransaction();
            connectionThreadLocal.set(connection);
        }
    }

    public static void endTransaction() {
        if (null != connectionThreadLocal.get()) {
            Connection connection = connectionThreadLocal.get();
            if (connection.isRollbackOnClose()) {
                connection.close();
            }
            connectionThreadLocal.remove();
        }
    }

    public static void commit() {
        connectionThreadLocal.get().commit();
    }

    public static void rollback() {
        if (null != connectionThreadLocal.get()) {
            log.warn("Rollback connection.");
            connectionThreadLocal.get().rollback();
        }
    }

    public AnimaQuery<T> bindSQL2o(Sql2o sql2o) {
        AnimaQuery.sql2o = sql2o;
        return this;
    }

    public static Sql2o getSql2o() {
        if (sql2o != null) {
            return sql2o;
        }
        Sql2o sql2o = Anima.me().getSql2o();
        if (null == sql2o) {
            throw new AnimaException("SQL2O instance not is null.");
        }
        return sql2o;
    }

    private void setJoin(List<T> models) {
        if (null == models || models.isEmpty() || this.joinParams.size() == 0) {
            return;
        }
        models.stream().filter(Objects::nonNull).forEach(this::setJoin);
    }

    private void setJoin(T model) {
        for (JoinParam joinParam : this.joinParams) {
            try {
                Object leftValue = AnimaUtils.invokeMethod(model, AnimaCache.getGetterName(joinParam.getOnLeft()), AnimaUtils.EMPTY_ARG);
                String sql = "SELECT * FROM " + AnimaCache.getTableName(joinParam.getJoinModel()) + " WHERE " + joinParam.getOnRight() + " = ?";
                Field field = model.getClass().getDeclaredField(joinParam.getFieldName());
                if (field.getType().equals(List.class)) {
                    if (AnimaUtils.isNotEmpty(joinParam.getOrderBy())) {
                        sql = sql + " ORDER BY " + joinParam.getOrderBy();
                    }
                    List<? extends Model> list = this.queryList(joinParam.getJoinModel(), sql, new Object[]{leftValue});
                    AnimaUtils.invokeMethod(model, AnimaCache.getSetterName(joinParam.getFieldName()), new Object[]{list});
                }
                if (!field.getType().equals(joinParam.getJoinModel())) continue;
                Model joinObject = this.queryOne(joinParam.getJoinModel(), sql, new Object[]{leftValue});
                AnimaUtils.invokeMethod(model, AnimaCache.getSetterName(joinParam.getFieldName()), new Object[]{joinObject});
            }
            catch (NoSuchFieldException e) {
                log.error("Set join error", (Throwable)e);
            }
        }
    }

    private void closeConn(Connection connection) {
        if (null == connectionThreadLocal.get() && null != connection) {
            connection.close();
        }
    }

    private void clean(Connection conn) {
        this.selectColumns = null;
        this.isSQLLimit = false;
        this.orderBySQL = new StringBuilder();
        this.conditionSQL = new StringBuilder();
        this.paramValues.clear();
        this.excludedColumns.clear();
        this.updateColumns.clear();
        if (null == connectionThreadLocal.get() && null != conn) {
            conn.close();
        }
    }

    public AnimaQuery() {
    }

    static {
        connectionThreadLocal = new ThreadLocal();
    }
}

