/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.rhino;

import cucumber.api.Scenario;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.Timeout;
import gherkin.TagExpression;
import gherkin.formatter.model.Tag;
import java.util.Arrays;
import java.util.Collection;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class RhinoHookDefinition
implements HookDefinition {
    private Context cx;
    private Scriptable scope;
    private Function fn;
    private final TagExpression tagExpression;
    private final int order;
    private final long timeoutMillis;
    private StackTraceElement location;

    public RhinoHookDefinition(Context cx, Scriptable scope, Function fn, String[] tagExpressions, int order, long timeoutMillis, StackTraceElement location) {
        this.cx = cx;
        this.scope = scope;
        this.fn = fn;
        this.tagExpression = new TagExpression(Arrays.asList(tagExpressions));
        this.order = order;
        this.timeoutMillis = timeoutMillis;
        this.location = location;
    }

    public String getLocation(boolean detail) {
        return this.location.getFileName() + ":" + this.location.getLineNumber();
    }

    public void execute(Scenario scenario) throws Throwable {
        final Object[] args = new Object[]{scenario};
        Timeout.timeout((Timeout.Callback)new Timeout.Callback<Object>(){

            public Object call() throws Throwable {
                return RhinoHookDefinition.this.fn.call(RhinoHookDefinition.this.cx, RhinoHookDefinition.this.scope, RhinoHookDefinition.this.scope, args);
            }
        }, (long)this.timeoutMillis);
    }

    public boolean matches(Collection<Tag> tags) {
        return this.tagExpression.evaluate(tags);
    }

    public int getOrder() {
        return this.order;
    }

    TagExpression getTagExpression() {
        return this.tagExpression;
    }

    long getTimeout() {
        return this.timeoutMillis;
    }

    public boolean isScenarioScoped() {
        return false;
    }
}

