/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.schemabuilder;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import info.archinnov.achilles.schemabuilder.SchemaStatement;
import java.util.ArrayList;
import java.util.List;

public abstract class TableOptions<T extends TableOptions> {
    static final String VALUE_SEPARATOR = " : ";
    static final String START_SUB_OPTIONS = "{";
    static final String SUB_OPTION_SEPARATOR = ", ";
    static final String END_SUB_OPTIONS = "}";
    static final String OPTION_ASSIGNMENT = " = ";
    static final String QUOTE = "'";
    static final String OPTION_SEPARATOR = " AND ";
    private SchemaStatement schemaStatement;
    private Optional<Caching> caching = Optional.absent();
    private Optional<Double> bloomFilterFPChance = Optional.absent();
    private Optional<String> comment = Optional.absent();
    private Optional<CompressionOptions> compressionOptions = Optional.absent();
    private Optional<CompactionOptions> compactionOptions = Optional.absent();
    private Optional<Double> dcLocalReadRepairChance = Optional.absent();
    private Optional<Integer> defaultTTL = Optional.absent();
    private Optional<Long> gcGraceSeconds = Optional.absent();
    private Optional<Integer> indexInterval = Optional.absent();
    private Optional<Long> memtableFlushPeriodInMillis = Optional.absent();
    private Optional<Boolean> populateIOOnCacheFlush = Optional.absent();
    private Optional<Double> readRepairChance = Optional.absent();
    private Optional<Boolean> replicateOnWrite = Optional.absent();
    private Optional<SpeculativeRetryValue> speculativeRetry = Optional.absent();

    TableOptions(SchemaStatement schemaStatement) {
        this.schemaStatement = schemaStatement;
    }

    public T caching(Caching caching) {
        this.caching = Optional.fromNullable((Object)((Object)caching));
        return (T)this;
    }

    public T bloomFilterFPChance(Double fpChance) {
        TableOptions.validateRateValue(fpChance, "Bloom filter false positive change");
        this.bloomFilterFPChance = Optional.fromNullable((Object)fpChance);
        return (T)this;
    }

    public T comment(String comment) {
        this.comment = Optional.fromNullable((Object)comment);
        return (T)this;
    }

    public T compressionOptions(CompressionOptions compressionOptions) {
        this.compressionOptions = Optional.fromNullable((Object)compressionOptions);
        return (T)this;
    }

    public T compactionOptions(CompactionOptions compactionOptions) {
        this.compactionOptions = Optional.fromNullable((Object)compactionOptions);
        return (T)this;
    }

    public T dcLocalReadRepairChance(Double dcLocalReadRepairChance) {
        TableOptions.validateRateValue(dcLocalReadRepairChance, "DC local read repair chance");
        this.dcLocalReadRepairChance = Optional.fromNullable((Object)dcLocalReadRepairChance);
        return (T)this;
    }

    public T defaultTimeToLive(Integer defaultTimeToLive) {
        this.defaultTTL = Optional.fromNullable((Object)defaultTimeToLive);
        return (T)this;
    }

    public T gcGraceSeconds(Long gcGraceSeconds) {
        this.gcGraceSeconds = Optional.fromNullable((Object)gcGraceSeconds);
        return (T)this;
    }

    public T indexInterval(Integer indexInterval) {
        this.indexInterval = Optional.fromNullable((Object)indexInterval);
        return (T)this;
    }

    public T memtableFlushPeriodInMillis(Long memtableFlushPeriodInMillis) {
        this.memtableFlushPeriodInMillis = Optional.fromNullable((Object)memtableFlushPeriodInMillis);
        return (T)this;
    }

    public T populateIOOnCacheFlush(Boolean populateIOOnCacheFlush) {
        this.populateIOOnCacheFlush = Optional.fromNullable((Object)populateIOOnCacheFlush);
        return (T)this;
    }

    public T readRepairChance(Double readRepairChance) {
        TableOptions.validateRateValue(readRepairChance, "Read repair chance");
        this.readRepairChance = Optional.fromNullable((Object)readRepairChance);
        return (T)this;
    }

    public T replicateOnWrite(Boolean replicateOnWrite) {
        this.replicateOnWrite = Optional.fromNullable((Object)replicateOnWrite);
        return (T)this;
    }

    public T speculativeRetry(SpeculativeRetryValue speculativeRetry) {
        this.speculativeRetry = Optional.fromNullable((Object)speculativeRetry);
        return (T)this;
    }

    List<String> buildCommonOptions() {
        ArrayList<String> options = new ArrayList<String>();
        if (this.caching.isPresent()) {
            options.add("caching" + OPTION_ASSIGNMENT + this.caching.get());
        }
        if (this.bloomFilterFPChance.isPresent()) {
            options.add("bloom_filter_fp_chance" + OPTION_ASSIGNMENT + this.bloomFilterFPChance.get());
        }
        if (this.comment.isPresent()) {
            options.add("comment" + OPTION_ASSIGNMENT + QUOTE + (String)this.comment.get() + QUOTE);
        }
        if (this.compressionOptions.isPresent()) {
            options.add("compression" + OPTION_ASSIGNMENT + ((CompressionOptions)this.compressionOptions.get()).build());
        }
        if (this.compactionOptions.isPresent()) {
            options.add("compaction" + OPTION_ASSIGNMENT + ((CompactionOptions)this.compactionOptions.get()).build());
        }
        if (this.dcLocalReadRepairChance.isPresent()) {
            options.add("dclocal_read_repair_chance" + OPTION_ASSIGNMENT + this.dcLocalReadRepairChance.get());
        }
        if (this.defaultTTL.isPresent()) {
            options.add("default_time_to_live" + OPTION_ASSIGNMENT + this.defaultTTL.get());
        }
        if (this.gcGraceSeconds.isPresent()) {
            options.add("gc_grace_seconds" + OPTION_ASSIGNMENT + this.gcGraceSeconds.get());
        }
        if (this.indexInterval.isPresent()) {
            options.add("index_interval" + OPTION_ASSIGNMENT + this.indexInterval.get());
        }
        if (this.memtableFlushPeriodInMillis.isPresent()) {
            options.add("memtable_flush_period_in_ms" + OPTION_ASSIGNMENT + this.memtableFlushPeriodInMillis.get());
        }
        if (this.populateIOOnCacheFlush.isPresent()) {
            options.add("populate_io_cache_on_flush" + OPTION_ASSIGNMENT + this.populateIOOnCacheFlush.get());
        }
        if (this.readRepairChance.isPresent()) {
            options.add("read_repair_chance" + OPTION_ASSIGNMENT + this.readRepairChance.get());
        }
        if (this.replicateOnWrite.isPresent()) {
            options.add("replicate_on_write" + OPTION_ASSIGNMENT + this.replicateOnWrite.get());
        }
        if (this.speculativeRetry.isPresent()) {
            options.add("speculative_retry" + OPTION_ASSIGNMENT + ((SpeculativeRetryValue)this.speculativeRetry.get()).value());
        }
        return options;
    }

    abstract String buildOptions();

    String build() {
        return this.schemaStatement.buildInternal();
    }

    static void validateRateValue(Double rateValue, String property) {
        if (rateValue != null && (rateValue < 0.0 || rateValue > 1.0)) {
            throw new IllegalArgumentException(property + " should be between 0 and 1");
        }
    }

    public static class SpeculativeRetryValue {
        private String value;

        private SpeculativeRetryValue(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static SpeculativeRetryValue none() {
            return new SpeculativeRetryValue("'NONE'");
        }

        public static SpeculativeRetryValue always() {
            return new SpeculativeRetryValue("'ALWAYS'");
        }

        public static SpeculativeRetryValue percentile(int percentile) {
            if (percentile < 0 || percentile > 100) {
                throw new IllegalArgumentException("Percentile value for speculative retry should be between 0 and 100");
            }
            return new SpeculativeRetryValue(TableOptions.QUOTE + percentile + "percentile'");
        }

        public static SpeculativeRetryValue millisecs(int millisecs) {
            if (millisecs < 0) {
                throw new IllegalArgumentException("Millisecond value for speculative retry should be positive");
            }
            return new SpeculativeRetryValue(TableOptions.QUOTE + millisecs + "ms'");
        }
    }

    public static class CompressionOptions {
        private Algorithm algorithm;
        private Optional<Integer> chunckLengthInKb = Optional.absent();
        private Optional<Double> crcCheckChance = Optional.absent();

        public CompressionOptions(Algorithm algorithm) {
            this.algorithm = algorithm;
        }

        public static CompressionOptions none() {
            return new NoCompression();
        }

        public static CompressionOptions lz4() {
            return new CompressionOptions(Algorithm.LZ4);
        }

        public static CompressionOptions snappy() {
            return new CompressionOptions(Algorithm.SNAPPY);
        }

        public static CompressionOptions deflate() {
            return new CompressionOptions(Algorithm.DEFLATE);
        }

        public CompressionOptions withChunkLengthInKb(Integer chunkLengthInKb) {
            this.chunckLengthInKb = Optional.fromNullable((Object)chunkLengthInKb);
            return this;
        }

        public CompressionOptions withCRCCheckChance(Double crcCheckChance) {
            TableOptions.validateRateValue(crcCheckChance, "CRC check chance");
            this.crcCheckChance = Optional.fromNullable((Object)crcCheckChance);
            return this;
        }

        public String build() {
            ArrayList<String> options = new ArrayList<String>();
            options.add("'sstable_compression'" + TableOptions.VALUE_SEPARATOR + this.algorithm.value());
            if (this.chunckLengthInKb.isPresent()) {
                options.add("'chunk_length_kb'" + TableOptions.VALUE_SEPARATOR + this.chunckLengthInKb.get());
            }
            if (this.crcCheckChance.isPresent()) {
                options.add("'crc_check_chance'" + TableOptions.VALUE_SEPARATOR + this.crcCheckChance.get());
            }
            return TableOptions.START_SUB_OPTIONS + Joiner.on((String)TableOptions.SUB_OPTION_SEPARATOR).join(options) + TableOptions.END_SUB_OPTIONS;
        }

        public static class NoCompression
        extends CompressionOptions {
            public NoCompression() {
                super(Algorithm.NONE);
            }

            @Override
            public CompressionOptions withChunkLengthInKb(Integer chunkLengthInKb) {
                return this;
            }

            @Override
            public CompressionOptions withCRCCheckChance(Double crcCheckChance) {
                return this;
            }
        }

        public static enum Algorithm {
            NONE("''"),
            LZ4("'LZ4Compressor'"),
            SNAPPY("'SnappyCompressor'"),
            DEFLATE("'DeflateCompressor'");

            private String value;

            private Algorithm(String value) {
                this.value = value;
            }

            public String value() {
                return this.value;
            }

            public String toString() {
                return this.value;
            }
        }
    }

    public static abstract class CompactionOptions<T extends CompactionOptions> {
        private Strategy strategy;
        private Optional<Double> bucketHigh = Optional.absent();
        private Optional<Double> bucketLow = Optional.absent();
        private Optional<Double> coldReadsRatioToOmit = Optional.absent();
        private Optional<Boolean> enableAutoCompaction = Optional.absent();
        private Optional<Integer> minThreshold = Optional.absent();
        private Optional<Integer> maxThreshold = Optional.absent();
        private Optional<Long> minSSTableSizeInBytes = Optional.absent();
        private Optional<Integer> ssTableSizeInMB = Optional.absent();
        private Optional<Integer> tombstoneCompactionIntervalInDay = Optional.absent();
        private Optional<Double> tombstoneThreshold = Optional.absent();

        private CompactionOptions(Strategy compactionStrategy) {
            this.strategy = compactionStrategy;
        }

        public static SizeTieredCompactionStrategyOptions sizedTieredStategy() {
            return new SizeTieredCompactionStrategyOptions();
        }

        public static LeveledCompactionStrategyOptions leveledStrategy() {
            return new LeveledCompactionStrategyOptions();
        }

        public T enableAutoCompaction(Boolean enableAutoCompaction) {
            this.enableAutoCompaction = Optional.fromNullable((Object)enableAutoCompaction);
            return (T)this;
        }

        public T maxThreshold(Integer maxThreshold) {
            this.maxThreshold = Optional.fromNullable((Object)maxThreshold);
            return (T)this;
        }

        public T tombstoneCompactionIntervalInDay(Integer tombstoneCompactionInterval) {
            this.tombstoneCompactionIntervalInDay = Optional.fromNullable((Object)tombstoneCompactionInterval);
            return (T)this;
        }

        public T tombstoneThreshold(Double tombstoneThreshold) {
            TableOptions.validateRateValue(tombstoneThreshold, "Tombstone threshold");
            this.tombstoneThreshold = Optional.fromNullable((Object)tombstoneThreshold);
            return (T)this;
        }

        List<String> buildCommonOptions() {
            ArrayList<String> options = new ArrayList<String>();
            options.add("'class'" + TableOptions.VALUE_SEPARATOR + this.strategy.strategyClass());
            if (this.enableAutoCompaction.isPresent()) {
                options.add("'enabled'" + TableOptions.VALUE_SEPARATOR + this.enableAutoCompaction.get());
            }
            if (this.maxThreshold.isPresent()) {
                options.add("'max_threshold'" + TableOptions.VALUE_SEPARATOR + this.maxThreshold.get());
            }
            if (this.tombstoneCompactionIntervalInDay.isPresent()) {
                options.add("'tombstone_compaction_interval'" + TableOptions.VALUE_SEPARATOR + this.tombstoneCompactionIntervalInDay.get());
            }
            if (this.tombstoneThreshold.isPresent()) {
                options.add("'tombstone_threshold'" + TableOptions.VALUE_SEPARATOR + this.tombstoneThreshold.get());
            }
            return options;
        }

        public abstract String build();

        public static enum Strategy {
            SIZED_TIERED("'SizeTieredCompactionStrategy'"),
            LEVELED("'LeveledCompactionStrategy'");

            private String strategyClass;

            private Strategy(String strategyClass) {
                this.strategyClass = strategyClass;
            }

            public String strategyClass() {
                return this.strategyClass;
            }

            public String toString() {
                return this.strategyClass;
            }
        }

        public static class LeveledCompactionStrategyOptions
        extends CompactionOptions<LeveledCompactionStrategyOptions> {
            private LeveledCompactionStrategyOptions() {
                super(Strategy.LEVELED);
            }

            public LeveledCompactionStrategyOptions ssTableSizeInMB(Integer ssTableSizeInMB) {
                ((CompactionOptions)this).ssTableSizeInMB = Optional.fromNullable((Object)ssTableSizeInMB);
                return this;
            }

            @Override
            public String build() {
                List<String> generalOptions = super.buildCommonOptions();
                ArrayList<String> options = new ArrayList<String>(generalOptions);
                if (((CompactionOptions)this).ssTableSizeInMB.isPresent()) {
                    options.add("'sstable_size_in_mb'" + TableOptions.VALUE_SEPARATOR + ((CompactionOptions)this).ssTableSizeInMB.get());
                }
                return TableOptions.START_SUB_OPTIONS + Joiner.on((String)TableOptions.SUB_OPTION_SEPARATOR).join(options) + TableOptions.END_SUB_OPTIONS;
            }
        }

        public static class SizeTieredCompactionStrategyOptions
        extends CompactionOptions<SizeTieredCompactionStrategyOptions> {
            private SizeTieredCompactionStrategyOptions() {
                super(Strategy.SIZED_TIERED);
            }

            public SizeTieredCompactionStrategyOptions bucketHigh(Double bucketHigh) {
                ((CompactionOptions)this).bucketHigh = Optional.fromNullable((Object)bucketHigh);
                return this;
            }

            public SizeTieredCompactionStrategyOptions bucketLow(Double bucketLow) {
                ((CompactionOptions)this).bucketLow = Optional.fromNullable((Object)bucketLow);
                return this;
            }

            public SizeTieredCompactionStrategyOptions coldReadsRatioToOmit(Double coldReadsRatio) {
                TableOptions.validateRateValue(coldReadsRatio, "Cold read ratio to omit ");
                ((CompactionOptions)this).coldReadsRatioToOmit = Optional.fromNullable((Object)coldReadsRatio);
                return this;
            }

            public SizeTieredCompactionStrategyOptions minThreshold(Integer minThreshold) {
                ((CompactionOptions)this).minThreshold = Optional.fromNullable((Object)minThreshold);
                return this;
            }

            public SizeTieredCompactionStrategyOptions minSSTableSizeInBytes(Long minSSTableSize) {
                ((CompactionOptions)this).minSSTableSizeInBytes = Optional.fromNullable((Object)minSSTableSize);
                return this;
            }

            @Override
            public String build() {
                List<String> generalOptions = super.buildCommonOptions();
                ArrayList<String> options = new ArrayList<String>(generalOptions);
                if (((CompactionOptions)this).bucketHigh.isPresent()) {
                    options.add("'bucket_high'" + TableOptions.VALUE_SEPARATOR + ((CompactionOptions)this).bucketHigh.get());
                }
                if (((CompactionOptions)this).bucketLow.isPresent()) {
                    options.add("'bucket_low'" + TableOptions.VALUE_SEPARATOR + ((CompactionOptions)this).bucketLow.get());
                }
                if (((CompactionOptions)this).coldReadsRatioToOmit.isPresent()) {
                    options.add("'cold_reads_to_omit'" + TableOptions.VALUE_SEPARATOR + ((CompactionOptions)this).coldReadsRatioToOmit.get());
                }
                if (((CompactionOptions)this).minThreshold.isPresent()) {
                    options.add("'min_threshold'" + TableOptions.VALUE_SEPARATOR + ((CompactionOptions)this).minThreshold.get());
                }
                if (((CompactionOptions)this).minSSTableSizeInBytes.isPresent()) {
                    options.add("'min_sstable_size'" + TableOptions.VALUE_SEPARATOR + ((CompactionOptions)this).minSSTableSizeInBytes.get());
                }
                return TableOptions.START_SUB_OPTIONS + Joiner.on((String)TableOptions.SUB_OPTION_SEPARATOR).join(options) + TableOptions.END_SUB_OPTIONS;
            }
        }
    }

    public static enum Caching {
        ALL("'all'"),
        KEYS_ONLY("'keys_only'"),
        ROWS_ONLY("'rows_only'"),
        NONE("'none'");

        private String value;

        private Caching(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

