/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.typed;

import com.datastax.driver.core.Statement;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.internal.async.EntitiesWithExecutionInfo;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.query.typed.AbstractTypedQuery;
import info.archinnov.achilles.query.typed.EntitiesWithPagingState;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTypedQuery<T>
extends AbstractTypedQuery<T> {
    private static final Logger log = LoggerFactory.getLogger(AsyncTypedQuery.class);

    public AsyncTypedQuery(Class<T> entityClass, DaoContext daoContext, ConfigurationContext configContext, Statement statement, EntityMeta meta, PersistenceContextFactory contextFactory, Object[] boundValues) {
        super(entityClass, daoContext, configContext, statement, meta, contextFactory, boundValues);
    }

    public AsyncTypedQuery<T> withProxy() {
        this.createProxy = true;
        return this;
    }

    public AchillesFuture<List<T>> get(FutureCallback<Object> ... asyncListeners) {
        ListenableFuture futures = super.asyncGetInternal(asyncListeners);
        ListenableFuture extractEntities = this.asyncUtils.transformFuture(futures, new Function<EntitiesWithExecutionInfo<T>, List<T>>(){

            @Nullable
            public List<T> apply(EntitiesWithExecutionInfo<T> input) {
                return input.getEntities();
            }
        });
        return this.asyncUtils.buildInterruptible(extractEntities);
    }

    public AchillesFuture<EntitiesWithPagingState<T>> getWithPagingState(FutureCallback<Object> ... asyncListeners) {
        ListenableFuture futures = super.asyncGetInternal(asyncListeners);
        ListenableFuture extractEntities = this.asyncUtils.transformFuture(futures, new Function<EntitiesWithExecutionInfo<T>, EntitiesWithPagingState<T>>(){

            @Nullable
            public EntitiesWithPagingState<T> apply(EntitiesWithExecutionInfo<T> input) {
                return input.toEntitiesWithPagingState();
            }
        });
        return this.asyncUtils.buildInterruptible(extractEntities);
    }

    public AchillesFuture<T> getFirst(FutureCallback<Object> ... asyncListeners) {
        return super.asyncGetFirstInternal(asyncListeners);
    }

    public AchillesFuture<Iterator<T>> iterator() {
        log.debug("Get iterator for typed query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        return this.asyncIteratorInternal((Optional<Integer>)Optional.absent(), NO_CALLBACKS);
    }

    public AchillesFuture<Iterator<T>> iterator(int fetchSize) {
        log.debug("Get iterator for typed query '{}'", (Object)this.nativeStatementWrapper.getStatement());
        return this.asyncIteratorInternal((Optional<Integer>)Optional.fromNullable((Object)fetchSize), NO_CALLBACKS);
    }
}

