/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.table;

import info.archinnov.achilles.exception.AchillesInvalidTableException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaNameNormalizer {
    protected static final Logger log = LoggerFactory.getLogger(SchemaNameNormalizer.class);
    public static final Pattern CF_PATTERN = Pattern.compile("[a-zA-Z0-9][a-zA-Z0-9_]{1,47}|\"[a-zA-Z0-9][a-zA-Z0-9_]{1,47}\"");

    public static String extractTableNameFromCanonical(String canonical) {
        return canonical.replaceAll(".+\\.(.+)", "$1");
    }

    public static String validateSchemaName(String name) {
        log.trace("Normalizing schema name '{}' name against Cassandra restrictions", (Object)name);
        Matcher nameMatcher = CF_PATTERN.matcher(name);
        if (nameMatcher.matches()) {
            return name;
        }
        throw new AchillesInvalidTableException("The schema name '" + name + "' is invalid. It should respect the pattern [a-zA-Z0-9][a-zA-Z0-9_]{1,47} optionally enclosed in double quotes (\")");
    }

    public static boolean isCaseSensitive(String name) {
        return name != null && !name.equals(name.toLowerCase());
    }
}

