/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.wrapper;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import info.archinnov.achilles.listener.LWTResultListener;
import java.util.concurrent.ExecutorService;

public class RegularStatementWrapper
extends AbstractStatementWrapper {
    private RegularStatement regularStatement;

    public RegularStatementWrapper(Class<?> entityClass, RegularStatement regularStatement, Object[] boundValues, ConsistencyLevel consistencyLevel, Optional<LWTResultListener> LWTResultListener2, Optional<ConsistencyLevel> serialConsistencyLevel) {
        super(entityClass, boundValues);
        this.regularStatement = regularStatement;
        this.lwtResultListener = LWTResultListener2;
        this.regularStatement.setConsistencyLevel(consistencyLevel);
        if (serialConsistencyLevel.isPresent()) {
            this.regularStatement.setSerialConsistencyLevel((ConsistencyLevel)serialConsistencyLevel.get());
        }
    }

    @Override
    public ListenableFuture<ResultSet> executeAsync(Session session, ExecutorService executorService) {
        this.activateQueryTracing();
        return super.executeAsyncInternal(session, this, executorService);
    }

    public RegularStatement getStatement() {
        return this.regularStatement;
    }

    @Override
    public String getQueryString() {
        return this.regularStatement.getQueryString();
    }

    @Override
    public void logDMLStatement(String indentation) {
        if (dmlLogger.isDebugEnabled() || this.displayDMLForEntity) {
            String queryType = "Parameterized statement";
            String queryString = this.regularStatement.getQueryString();
            String consistencyLevel = this.regularStatement.getConsistencyLevel() == null ? "DEFAULT" : this.regularStatement.getConsistencyLevel().name();
            this.writeDMLStatementLog(queryType, queryString, consistencyLevel, this.values);
        }
    }

    @Override
    public void releaseResources() {
    }
}

