/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.reflection;

import com.datastax.driver.core.Row;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internal.cql.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowMethodInvoker {
    private static final Logger log = LoggerFactory.getLogger(RowMethodInvoker.class);

    public <T> T invokeOnRowForType(Row row, Class<T> type, String name) {
        log.trace("Extract property {} of type {} from CQL row ", (Object)name, type);
        try {
            return (T)TypeMapper.getRowMethod(type).invoke((Object)row, name);
        }
        catch (Exception e) {
            throw new AchillesException("Cannot retrieve column '" + name + "' of type '" + type.getCanonicalName() + "' from CQL Row", (Throwable)e);
        }
    }

    public static enum Singleton {
        INSTANCE;

        private final RowMethodInvoker instance = new RowMethodInvoker();

        public RowMethodInvoker get() {
            return this.instance;
        }
    }
}

