/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.reflection;

import java.lang.reflect.Field;

public class FieldAccessor {
    public <T> T getValueFromField(Field field, Object instance) throws IllegalAccessException {
        Object result = null;
        if (instance != null) {
            this.makeFieldAccessibleIfNeeded(field);
            result = field.get(instance);
        }
        return (T)result;
    }

    public void setValueToField(Field field, Object instance, Object value) throws IllegalAccessException {
        if (instance != null) {
            this.makeFieldAccessibleIfNeeded(field);
            field.set(instance, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeFieldAccessibleIfNeeded(Field field) {
        if (!field.isAccessible()) {
            Field field2 = field;
            synchronized (field2) {
                field.setAccessible(true);
            }
        }
    }

    public static enum Singleton {
        INSTANCE;

        private final FieldAccessor instance = new FieldAccessor();

        public FieldAccessor get() {
            return this.instance;
        }
    }
}

