/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing;

import info.archinnov.achilles.annotations.Column;
import info.archinnov.achilles.annotations.Consistency;
import info.archinnov.achilles.annotations.EmptyCollectionIfNull;
import info.archinnov.achilles.annotations.Id;
import info.archinnov.achilles.annotations.Index;
import info.archinnov.achilles.annotations.PartitionKey;
import info.archinnov.achilles.annotations.TimeUUID;
import info.archinnov.achilles.codec.Codec;
import info.archinnov.achilles.interceptor.Interceptor;
import info.archinnov.achilles.internal.metadata.codec.ListCodec;
import info.archinnov.achilles.internal.metadata.codec.MapCodec;
import info.archinnov.achilles.internal.metadata.codec.SetCodec;
import info.archinnov.achilles.internal.metadata.holder.CompoundPKProperties;
import info.archinnov.achilles.internal.metadata.holder.CounterProperties;
import info.archinnov.achilles.internal.metadata.holder.IndexProperties;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaBuilder;
import info.archinnov.achilles.internal.metadata.holder.PropertyType;
import info.archinnov.achilles.internal.metadata.parsing.CodecFactory;
import info.archinnov.achilles.internal.metadata.parsing.CompoundPKParser;
import info.archinnov.achilles.internal.metadata.parsing.EntityIntrospector;
import info.archinnov.achilles.internal.metadata.parsing.PropertyFilter;
import info.archinnov.achilles.internal.metadata.parsing.TypeParser;
import info.archinnov.achilles.internal.metadata.parsing.context.PropertyParsingContext;
import info.archinnov.achilles.internal.metadata.parsing.validator.PropertyParsingValidator;
import info.archinnov.achilles.internal.utils.Pair;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.Counter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyParser {
    private static final Logger log = LoggerFactory.getLogger(PropertyFilter.class);
    public static Set<Class<?>> allowedTypes = new HashSet();
    private EntityIntrospector entityIntrospector = EntityIntrospector.Singleton.INSTANCE.get();
    private PropertyParsingValidator validator = PropertyParsingValidator.Singleton.INSTANCE.get();
    private PropertyFilter filter = PropertyFilter.Singleton.INSTANCE.get();
    private CodecFactory codecFactory = CodecFactory.Singleton.INSTANCE.get();

    public static String getIndexName(Field field) {
        log.debug("Check @Index annotation on field {} of class {}", (Object)field.getName(), (Object)field.getDeclaringClass().getCanonicalName());
        String indexName = null;
        Index index = field.getAnnotation(Index.class);
        if (index != null) {
            indexName = index.name();
        }
        return indexName;
    }

    public static <T> boolean isSupportedNativeType(Class<T> valueClass) {
        return valueClass != null && (allowedTypes.contains(valueClass) || ByteBuffer.class.isAssignableFrom(valueClass));
    }

    public static <T> boolean isAssignableFromNativeType(Class<T> valueClass) {
        for (Class<T> clazz : allowedTypes) {
            if (!clazz.isAssignableFrom(valueClass)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean isSupportedType(Class<T> valueClass) {
        return PropertyParser.isSupportedNativeType(valueClass) || valueClass != null && valueClass.isEnum();
    }

    public Pair<ConsistencyLevel, ConsistencyLevel> findConsistencyLevels(Field field, Pair<ConsistencyLevel, ConsistencyLevel> defaultConsistencyLevels) {
        log.debug("Find consistency configuration for field {} of class {}", (Object)field.getName(), (Object)field.getDeclaringClass().getCanonicalName());
        Consistency clevel = field.getAnnotation(Consistency.class);
        ConsistencyLevel defaultGlobalRead = (ConsistencyLevel)defaultConsistencyLevels.left;
        ConsistencyLevel defaultGlobalWrite = (ConsistencyLevel)defaultConsistencyLevels.right;
        if (clevel != null) {
            defaultGlobalRead = clevel.read();
            defaultGlobalWrite = clevel.write();
        }
        log.trace("Found consistency levels : {} / {}", (Object)defaultGlobalRead, (Object)defaultGlobalWrite);
        return Pair.create(defaultGlobalRead, defaultGlobalWrite);
    }

    public Class<?> inferEntityClassFromInterceptor(Interceptor<?> interceptor) {
        for (Type type : interceptor.getClass().getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            return TypeParser.getClassFromType(actualTypeArguments[0]);
        }
        return null;
    }

    public PropertyMeta parse(PropertyParsingContext context) {
        PropertyMeta propertyMeta;
        log.debug("Parsing property {} of entity class {}", (Object)context.getCurrentPropertyName(), (Object)context.getCurrentEntityClass().getCanonicalName());
        Field field = context.getCurrentField();
        context.setCustomConsistencyLevels(this.filter.hasAnnotation(context.getCurrentField(), Consistency.class));
        this.validator.validateNoDuplicatePropertyName(context);
        this.validator.validateIndexIfSet(context);
        Class<?> fieldType = field.getType();
        if (List.class.isAssignableFrom(fieldType)) {
            propertyMeta = this.parseListProperty(context);
        } else if (Set.class.isAssignableFrom(fieldType)) {
            propertyMeta = this.parseSetProperty(context);
        } else if (Map.class.isAssignableFrom(fieldType)) {
            propertyMeta = this.parseMapProperty(context);
        } else if (Counter.class.isAssignableFrom(fieldType)) {
            propertyMeta = this.parseCounterProperty(context);
        } else if (context.isCompoundPrimaryKey()) {
            propertyMeta = this.parseCompoundPrimaryKey(context);
        } else if (context.isPrimaryKey()) {
            propertyMeta = this.parsePartitionKey(context);
        } else {
            propertyMeta = this.parseSimpleProperty(context);
            String indexName = PropertyParser.getIndexName(field);
            if (indexName != null) {
                propertyMeta.setIndexProperties(new IndexProperties(indexName, propertyMeta.getCQLColumnName()));
            }
        }
        context.getPropertyMetas().put(context.getCurrentPropertyName(), propertyMeta);
        this.validator.validateNoDuplicateCQLName(context);
        return propertyMeta;
    }

    protected PropertyMeta parsePartitionKey(PropertyParsingContext context) {
        log.debug("Parsing property {} as id of entity class {}", (Object)context.getCurrentPropertyName(), (Object)context.getCurrentEntityClass().getCanonicalName());
        PropertyMeta idMeta = this.parseSimpleProperty(context);
        idMeta.setType(PropertyType.PARTITION_KEY);
        Id id = context.getCurrentField().getAnnotation(Id.class);
        PartitionKey partitionKey = context.getCurrentField().getAnnotation(PartitionKey.class);
        Column column = context.getCurrentField().getAnnotation(Column.class);
        if (partitionKey != null) {
            Validator.validateBeanMappingTrue(partitionKey.value() == 1, "Partition key order should be equal to 1 for simple primary key for entity '%s'", context.getCurrentEntityClass().getCanonicalName());
        }
        String cqlColumnName = id != null && StringUtils.isNotBlank((CharSequence)id.name()) ? id.name() : (column != null && StringUtils.isNotBlank((CharSequence)column.name()) ? column.name() : context.getCurrentCQLColumnName());
        idMeta.setCQLColumnName(cqlColumnName);
        idMeta.setPropertyName(context.getCurrentPropertyName());
        return idMeta;
    }

    protected PropertyMeta parseCompoundPrimaryKey(PropertyParsingContext context) {
        log.debug("Parsing property {} as compound primary key of entity class {}", (Object)context.getCurrentPropertyName(), (Object)context.getCurrentEntityClass().getCanonicalName());
        Class entityClass = context.getCurrentEntityClass();
        Field field = context.getCurrentField();
        Class<?> compoundPKClass = field.getType();
        Validator.validateInstantiable(compoundPKClass);
        Method[] accessors = this.entityIntrospector.findAccessors(entityClass, field);
        PropertyType type = PropertyType.COMPOUND_PRIMARY_KEY;
        CompoundPKProperties compoundPKProperties = this.extractCopoundPKProperties(compoundPKClass, context);
        PropertyMeta propertyMeta = PropertyMetaBuilder.factory().objectMapper(context.getCurrentObjectMapper()).type(type).propertyName(context.getCurrentPropertyName()).compoundPKProperties(compoundPKProperties).entityClassName(context.getCurrentEntityClass().getCanonicalName()).accessors(accessors).field(field).consistencyLevels(context.getCurrentConsistencyLevels()).build(Void.class, compoundPKClass);
        log.trace("Built compound primary key meta for property {} of entity class {} : {}", new Object[]{propertyMeta.getPropertyName(), context.getCurrentEntityClass().getCanonicalName(), propertyMeta});
        return propertyMeta;
    }

    protected PropertyMeta parseSimpleProperty(PropertyParsingContext context) {
        log.debug("Parsing property {} as simple property of entity class {}", (Object)context.getCurrentPropertyName(), (Object)context.getCurrentEntityClass().getCanonicalName());
        Class entityClass = context.getCurrentEntityClass();
        Field field = context.getCurrentField();
        boolean staticColumn = this.isStaticColumn(field);
        boolean timeUUID = this.isTimeUUID(context, field);
        Method[] accessors = this.entityIntrospector.findAccessors(entityClass, field);
        Codec simpleCodec = this.codecFactory.parseSimpleField(context);
        Class<?> cqlValueType = this.codecFactory.determineCQLValueType(simpleCodec, timeUUID);
        PropertyType type = PropertyType.SIMPLE;
        PropertyMeta propertyMeta = PropertyMetaBuilder.factory().objectMapper(context.getCurrentObjectMapper()).type(type).propertyName(context.getCurrentPropertyName()).cqlColumnName(context.getCurrentCQLColumnName()).entityClassName(context.getCurrentEntityClass().getCanonicalName()).accessors(accessors).consistencyLevels(context.getCurrentConsistencyLevels()).field(field).timeuuid(timeUUID).staticColumn(staticColumn).simpleCodec(simpleCodec).cqlValueClass(cqlValueType).build(Void.class, field.getType());
        log.trace("Built simple property meta for property {} of entity class {} : {}", new Object[]{propertyMeta.getPropertyName(), context.getCurrentEntityClass().getCanonicalName(), propertyMeta});
        return propertyMeta;
    }

    protected PropertyMeta parseCounterProperty(PropertyParsingContext context) {
        log.debug("Parsing property {} as counter property of entity class {}", (Object)context.getCurrentPropertyName(), (Object)context.getCurrentEntityClass().getCanonicalName());
        Class entityClass = context.getCurrentEntityClass();
        Field field = context.getCurrentField();
        Method[] accessors = this.entityIntrospector.findAccessors(entityClass, field);
        boolean staticColumn = this.isStaticColumn(field);
        PropertyType type = PropertyType.COUNTER;
        CounterProperties counterProperties = new CounterProperties(context.getCurrentEntityClass().getCanonicalName());
        PropertyMeta propertyMeta = PropertyMetaBuilder.factory().objectMapper(context.getCurrentObjectMapper()).type(type).propertyName(context.getCurrentPropertyName()).cqlColumnName(context.getCurrentCQLColumnName()).entityClassName(context.getCurrentEntityClass().getCanonicalName()).accessors(accessors).field(field).counterProperties(counterProperties).consistencyLevels(context.getCurrentConsistencyLevels()).staticColumn(staticColumn).cqlValueClass(Long.class).build(Void.class, field.getType());
        context.hasSimpleCounterType();
        context.getCounterMetas().add(propertyMeta);
        if (context.isCustomConsistencyLevels()) {
            this.parseSimpleCounterConsistencyLevel(context, propertyMeta);
        }
        log.trace("Built simple property meta for property {} of entity class {} : {}", new Object[]{propertyMeta.getPropertyName(), context.getCurrentEntityClass().getCanonicalName(), propertyMeta});
        return propertyMeta;
    }

    public <V> PropertyMeta parseListProperty(PropertyParsingContext context) {
        log.debug("Parsing property {} as list property of entity class {}", (Object)context.getCurrentPropertyName(), (Object)context.getCurrentEntityClass().getCanonicalName());
        Class entityClass = context.getCurrentEntityClass();
        Field field = context.getCurrentField();
        boolean timeUUID = this.isTimeUUID(context, field);
        boolean emptyCollectionIfNull = this.mapNullCollectionAndMapToEmpty(field);
        boolean staticColumn = this.isStaticColumn(field);
        Type genericType = field.getGenericType();
        Class valueClass = TypeParser.inferValueClassForListOrSet(genericType, entityClass);
        Method[] accessors = this.entityIntrospector.findAccessors(entityClass, field);
        ListCodec listCodec = this.codecFactory.parseListField(context);
        Class<?> cqlValueType = this.codecFactory.determineCQLValueType(listCodec, timeUUID);
        PropertyType type = PropertyType.LIST;
        PropertyMeta listMeta = PropertyMetaBuilder.factory().objectMapper(context.getCurrentObjectMapper()).type(type).propertyName(context.getCurrentPropertyName()).cqlColumnName(context.getCurrentCQLColumnName()).entityClassName(context.getCurrentEntityClass().getCanonicalName()).consistencyLevels(context.getCurrentConsistencyLevels()).accessors(accessors).field(field).timeuuid(timeUUID).emptyCollectionAndMapIfNull(emptyCollectionIfNull).staticColumn(staticColumn).listCodec(listCodec).cqlValueClass(cqlValueType).build(Void.class, valueClass);
        log.trace("Built list property meta for property {} of entity class {} : {}", new Object[]{listMeta.getPropertyName(), context.getCurrentEntityClass().getCanonicalName(), listMeta});
        return listMeta;
    }

    public <V> PropertyMeta parseSetProperty(PropertyParsingContext context) {
        log.debug("Parsing property {} as set property of entity class {}", (Object)context.getCurrentPropertyName(), (Object)context.getCurrentEntityClass().getCanonicalName());
        Class entityClass = context.getCurrentEntityClass();
        Field field = context.getCurrentField();
        boolean timeUUID = this.isTimeUUID(context, field);
        boolean emptyCollectionIfNull = this.mapNullCollectionAndMapToEmpty(field);
        boolean staticColumn = this.isStaticColumn(field);
        Type genericType = field.getGenericType();
        Class valueClass = TypeParser.inferValueClassForListOrSet(genericType, entityClass);
        Method[] accessors = this.entityIntrospector.findAccessors(entityClass, field);
        SetCodec setCodec = this.codecFactory.parseSetField(context);
        Class<?> cqlValueType = this.codecFactory.determineCQLValueType(setCodec, timeUUID);
        PropertyType type = PropertyType.SET;
        PropertyMeta setMeta = PropertyMetaBuilder.factory().objectMapper(context.getCurrentObjectMapper()).type(type).propertyName(context.getCurrentPropertyName()).cqlColumnName(context.getCurrentCQLColumnName()).entityClassName(context.getCurrentEntityClass().getCanonicalName()).consistencyLevels(context.getCurrentConsistencyLevels()).accessors(accessors).field(field).timeuuid(timeUUID).emptyCollectionAndMapIfNull(emptyCollectionIfNull).staticColumn(staticColumn).setCodec(setCodec).cqlValueClass(cqlValueType).build(Void.class, valueClass);
        log.trace("Built set property meta for property {} of  entity class {} : {}", new Object[]{setMeta.getPropertyName(), context.getCurrentEntityClass().getCanonicalName(), setMeta});
        return setMeta;
    }

    protected <K, V> PropertyMeta parseMapProperty(PropertyParsingContext context) {
        log.debug("Parsing property {} as map property of entity class {}", (Object)context.getCurrentPropertyName(), (Object)context.getCurrentEntityClass().getCanonicalName());
        Class entityClass = context.getCurrentEntityClass();
        Field field = context.getCurrentField();
        boolean timeUUID = this.isTimeUUID(context, field);
        boolean emptyCollectionIfNull = this.mapNullCollectionAndMapToEmpty(field);
        boolean staticColumn = this.isStaticColumn(field);
        this.validator.validateMapGenerics(field, entityClass);
        Pair types = TypeParser.determineMapGenericTypes(field);
        Class keyClass = (Class)types.left;
        Class valueClass = (Class)types.right;
        Method[] accessors = this.entityIntrospector.findAccessors(entityClass, field);
        MapCodec mapCodec = this.codecFactory.parseMapField(context);
        Class<?> cqlKeyType = this.codecFactory.determineCQLKeyType(mapCodec, timeUUID);
        Class<?> cqlValueType = this.codecFactory.determineCQLValueType(mapCodec, timeUUID);
        PropertyType type = PropertyType.MAP;
        PropertyMeta mapMeta = PropertyMetaBuilder.factory().objectMapper(context.getCurrentObjectMapper()).type(type).propertyName(context.getCurrentPropertyName()).cqlColumnName(context.getCurrentCQLColumnName()).entityClassName(context.getCurrentEntityClass().getCanonicalName()).consistencyLevels(context.getCurrentConsistencyLevels()).accessors(accessors).field(field).timeuuid(timeUUID).emptyCollectionAndMapIfNull(emptyCollectionIfNull).staticColumn(staticColumn).mapCodec(mapCodec).cqlKeyClass(cqlKeyType).cqlValueClass(cqlValueType).build(keyClass, valueClass);
        log.trace("Built map property meta for property {} of entity class {} : {}", new Object[]{mapMeta.getPropertyName(), context.getCurrentEntityClass().getCanonicalName(), mapMeta});
        return mapMeta;
    }

    private CompoundPKProperties extractCopoundPKProperties(Class<?> keyClass, PropertyParsingContext context) {
        log.trace("Parsing compound key class", (Object)keyClass.getCanonicalName());
        CompoundPKProperties compoundPKProperties = new CompoundPKParser(context).parseCompoundPK(keyClass, this);
        log.trace("Built compound key properties", (Object)compoundPKProperties);
        return compoundPKProperties;
    }

    private void parseSimpleCounterConsistencyLevel(PropertyParsingContext context, PropertyMeta propertyMeta) {
        log.trace("Parse custom consistency levels for counter property {}", (Object)propertyMeta);
        Pair<ConsistencyLevel, ConsistencyLevel> consistencyLevels = this.findConsistencyLevels(context.getCurrentField(), context.getCurrentConsistencyLevels());
        this.validator.validateConsistencyLevelForCounter(context, consistencyLevels);
        log.trace("Found custom consistency levels : {}", consistencyLevels);
        propertyMeta.setConsistencyLevels(consistencyLevels);
    }

    private boolean isTimeUUID(PropertyParsingContext context, Field field) {
        boolean timeUUID = false;
        if (this.filter.hasAnnotation(field, TimeUUID.class)) {
            Validator.validateBeanMappingTrue(field.getType().equals(UUID.class), "The field '%s' from class '%s' annotated with @TimeUUID should be of java.util.UUID type", field.getName(), context.getCurrentEntityClass().getCanonicalName());
            timeUUID = true;
        }
        return timeUUID;
    }

    private boolean mapNullCollectionAndMapToEmpty(Field field) {
        return this.filter.hasAnnotation(field, EmptyCollectionIfNull.class) || this.filter.hasAnnotation(field, NotNull.class);
    }

    private boolean isStaticColumn(Field field) {
        Column column = field.getAnnotation(Column.class);
        return column != null && column.staticColumn();
    }

    static {
        allowedTypes.add(Byte.TYPE);
        allowedTypes.add(Byte.class);
        allowedTypes.add(byte[].class);
        allowedTypes.add(ByteBuffer.class);
        allowedTypes.add(Boolean.class);
        allowedTypes.add(Boolean.TYPE);
        allowedTypes.add(Date.class);
        allowedTypes.add(Double.class);
        allowedTypes.add(Double.TYPE);
        allowedTypes.add(BigDecimal.class);
        allowedTypes.add(Float.class);
        allowedTypes.add(Float.TYPE);
        allowedTypes.add(InetAddress.class);
        allowedTypes.add(BigInteger.class);
        allowedTypes.add(Integer.class);
        allowedTypes.add(Integer.TYPE);
        allowedTypes.add(Long.class);
        allowedTypes.add(Long.TYPE);
        allowedTypes.add(String.class);
        allowedTypes.add(UUID.class);
    }

    public static enum Singleton {
        INSTANCE;

        private final PropertyParser instance = new PropertyParser();

        public PropertyParser get() {
            return this.instance;
        }
    }
}

