/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import com.datastax.driver.core.Row;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internal.cql.TypeMapper;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaView;
import info.archinnov.achilles.internal.validation.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMetaRowExtractor
extends PropertyMetaView {
    private static final Logger log = LoggerFactory.getLogger(PropertyMetaRowExtractor.class);

    protected PropertyMetaRowExtractor(PropertyMeta meta) {
        super(meta);
    }

    public List<Object> extractRawCompoundPrimaryComponentsFromRow(Row row, boolean hasStaticColumns) {
        Object rawValue;
        Class<?> componentClass;
        int index;
        log.trace("Extract raw compound primary components from CQL row {} for id meta {}", (Object)row, (Object)this.meta);
        Validator.validateNotNull(this.meta.getCompoundPKProperties(), "Cannot extract raw compound primary keys from CQL row because entity '%s' does not have a compound primary key", this.meta.getEntityClassName());
        List<Class<?>> componentClasses = this.meta.getCompoundPKProperties().getCQLComponentClasses();
        List<String> cqlComponentNames = this.meta.getCompoundPKProperties().getCQLComponentNames();
        int partitionComponentsCount = this.meta.getCompoundPKProperties().getPartitionComponents().getCQLComponentNames().size();
        ArrayList<Object> rawValues = new ArrayList<Object>(Collections.nCopies(cqlComponentNames.size(), null));
        for (index = 0; index < partitionComponentsCount; ++index) {
            componentClass = componentClasses.get(index);
            try {
                rawValue = TypeMapper.getRowMethod(componentClass).invoke((Object)row, cqlComponentNames.get(index));
            }
            catch (Exception e) {
                throw new AchillesException(String.format("Cannot retrieve partition key(s) for entity class '%s' from CQL Row", this.meta.getEntityClassName()), (Throwable)e);
            }
            rawValues.set(index, rawValue);
        }
        for (index = partitionComponentsCount; index < cqlComponentNames.size(); ++index) {
            componentClass = componentClasses.get(index);
            try {
                rawValue = TypeMapper.getRowMethod(componentClass).invoke((Object)row, cqlComponentNames.get(index));
            }
            catch (Exception e) {
                if (hasStaticColumns) {
                    rawValue = null;
                }
                throw new AchillesException(String.format("Cannot retrieve compound primary key for entity class '%s' from CQL Row", this.meta.getEntityClassName()), (Throwable)e);
            }
            rawValues.set(index, rawValue);
        }
        return rawValues;
    }

    public Object invokeOnRowForFields(Row row) {
        if (log.isTraceEnabled()) {
            log.trace("Extract column {} from CQL row {} for id meta {}", new Object[]{this.meta.getCQLColumnName(), row, this.meta});
        }
        Object value = null;
        if (!row.isNull(this.meta.getCQLColumnName())) {
            switch (this.meta.type()) {
                case LIST: {
                    value = this.invokeOnRowForList(row);
                    break;
                }
                case SET: {
                    value = this.invokeOnRowForSet(row);
                    break;
                }
                case MAP: {
                    value = this.invokeOnRowForMap(row);
                    break;
                }
                case PARTITION_KEY: 
                case SIMPLE: {
                    value = this.invokeOnRowForProperty(row);
                    break;
                }
            }
        } else {
            switch (this.meta.type()) {
                case LIST: 
                case SET: 
                case MAP: {
                    value = this.meta.forValues().nullValueForCollectionAndMap();
                    break;
                }
            }
        }
        return value;
    }

    public Object extractCompoundPrimaryKeyFromRow(Row row, EntityMeta entityMeta, EntityMeta.EntityState entityState) {
        log.trace("Extract compound primary key {} from CQL row for entity class {}", (Object)this.meta.getPropertyName(), (Object)this.meta.getEntityClassName());
        boolean hasSomeStaticValue = this.rowHasSomeStaticValue(row, entityMeta);
        List<Object> rawComponents = this.extractRawCompoundPrimaryComponentsFromRow(row, hasSomeStaticValue);
        if (entityState.isManaged() && !entityMeta.structure().hasOnlyStaticColumns() && !hasSomeStaticValue) {
            this.validateExtractedCompoundPrimaryComponents(rawComponents);
        }
        return this.meta.forTranscoding().decodeFromComponents(rawComponents);
    }

    protected boolean rowHasSomeStaticValue(Row row, EntityMeta entityMeta) {
        boolean hasSomeStaticValue = false;
        List<PropertyMeta> allStaticMetas = entityMeta.getAllStaticMetas();
        for (PropertyMeta staticMeta : allStaticMetas) {
            switch (staticMeta.type()) {
                case SIMPLE: {
                    try {
                        hasSomeStaticValue = staticMeta.forRowExtraction().invokeOnRowForProperty(row) != null;
                    }
                    catch (AchillesException achillesException) {}
                    break;
                }
                case LIST: {
                    try {
                        hasSomeStaticValue = staticMeta.forRowExtraction().invokeOnRowForList(row) != null;
                    }
                    catch (AchillesException achillesException) {}
                    break;
                }
                case SET: {
                    try {
                        hasSomeStaticValue = staticMeta.forRowExtraction().invokeOnRowForSet(row) != null;
                    }
                    catch (AchillesException achillesException) {}
                    break;
                }
                case MAP: {
                    try {
                        hasSomeStaticValue = staticMeta.forRowExtraction().invokeOnRowForMap(row) != null;
                    }
                    catch (AchillesException achillesException) {}
                    break;
                }
            }
            if (!hasSomeStaticValue) continue;
            break;
        }
        return hasSomeStaticValue;
    }

    public void validateExtractedCompoundPrimaryComponents(List<Object> rawComponents) {
        log.trace("Validate raw compound primary components {} for id meta {}", rawComponents, (Object)this.meta);
        Validator.validateNotNull(this.meta.getCompoundPKProperties(), "Cannot validate raw compound primary keys from CQL row because entity '%s' does not have a compound primary key", this.meta.getEntityClassName());
        List<String> cqlComponentNames = this.meta.getCompoundPKProperties().getCQLComponentNames();
        for (int i = 0; i < cqlComponentNames.size(); ++i) {
            Validator.validateNotNull(rawComponents.get(i), "Error, the component '%s' from @CompoundPrimaryKey class '%s' is null in Cassandra", cqlComponentNames.get(i), this.meta.getValueClass());
        }
    }

    protected Object invokeOnRowForProperty(Row row) {
        String cqlColumnName = this.meta.getCQLColumnName();
        String entityClassName = this.meta.getEntityClassName();
        log.trace("Extract property {} from CQL row for entity class {}", (Object)cqlColumnName, (Object)entityClassName);
        try {
            Object rawValue = TypeMapper.getRowMethod(this.meta.getCqlValueClass()).invoke((Object)row, cqlColumnName);
            return this.meta.forTranscoding().decodeFromCassandra(rawValue);
        }
        catch (Exception e) {
            throw new AchillesException(String.format("Cannot retrieve property '%s' for entity class '%S' from CQL Row", cqlColumnName, entityClassName), (Throwable)e);
        }
    }

    protected Object invokeOnRowForList(Row row) {
        String cqlColumnName = this.meta.getCQLColumnName();
        String entityClassName = this.meta.getEntityClassName();
        log.trace("Extract list property {} from CQL row for entity class {}", (Object)cqlColumnName, (Object)entityClassName);
        try {
            List rawValues = row.getList(cqlColumnName, TypeMapper.toCompatibleJavaType(this.meta.getCqlValueClass()));
            return this.meta.forTranscoding().decodeFromCassandra(rawValues);
        }
        catch (Exception e) {
            throw new AchillesException(String.format("Cannot retrieve list property '%s' for entity class '%S' from CQL Row", cqlColumnName, entityClassName), (Throwable)e);
        }
    }

    protected Object invokeOnRowForSet(Row row) {
        String cqlColumnName = this.meta.getCQLColumnName();
        String entityClassName = this.meta.getEntityClassName();
        log.trace("Extract set property {} from CQL row for entity class {}", (Object)cqlColumnName, (Object)entityClassName);
        try {
            Set rawValues = row.getSet(cqlColumnName, TypeMapper.toCompatibleJavaType(this.meta.getCqlValueClass()));
            return this.meta.forTranscoding().decodeFromCassandra(rawValues);
        }
        catch (Exception e) {
            throw new AchillesException(String.format("Cannot retrieve set property '%s' for entity class '%S' from CQL Row", cqlColumnName, entityClassName), (Throwable)e);
        }
    }

    protected Object invokeOnRowForMap(Row row) {
        String cqlColumnName = this.meta.getCQLColumnName();
        String entityClassName = this.meta.getEntityClassName();
        log.trace("Extract map property {} from CQL row for entity class {}", (Object)cqlColumnName, (Object)entityClassName);
        try {
            Map rawValues = row.getMap(cqlColumnName, TypeMapper.toCompatibleJavaType(this.meta.getCQLKeyClass()), TypeMapper.toCompatibleJavaType(this.meta.getCqlValueClass()));
            return this.meta.forTranscoding().decodeFromCassandra(rawValues);
        }
        catch (Exception e) {
            throw new AchillesException(String.format("Cannot retrieve map property '%s' for entity class '%S' from CQL Row", cqlColumnName, entityClassName), (Throwable)e);
        }
    }
}

