/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import info.archinnov.achilles.internal.metadata.holder.AbstractComponentProperties;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.validation.Validator;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionComponents
extends AbstractComponentProperties {
    private static final Logger log = LoggerFactory.getLogger(PartitionComponents.class);

    public PartitionComponents(List<PropertyMeta> partitionKeyMetas) {
        super(partitionKeyMetas);
    }

    void validatePartitionComponents(String className, Object ... partitionComponentsArray) {
        List<Class<?>> componentClasses = this.getComponentClasses();
        Validator.validateTrue(ArrayUtils.isNotEmpty((Object[])partitionComponentsArray), "There should be at least one partition key component provided for querying on entity '%s'", className);
        List<Object> partitionComponents = Arrays.asList(partitionComponentsArray);
        log.trace("Validate partition components {} for slice query on entity class {}", partitionComponents, (Object)className);
        Validator.validateTrue(partitionComponents.size() > 0, "There should be at least one partition key component provided for querying on entity '%s'", className);
        Validator.validateTrue(partitionComponents.size() <= componentClasses.size(), "The partition key components count should be less or equal to '%s' for querying on entity '%s'", componentClasses.size(), className);
        for (int i = 0; i < partitionComponents.size(); ++i) {
            Object partitionKeyComponent = partitionComponents.get(i);
            Validator.validateNotNull(partitionKeyComponent, "The '%sth' partition key component should not be null", i + 1);
            Class<?> currentPartitionComponentType = partitionKeyComponent.getClass();
            Class<?> expectedPartitionComponentType = componentClasses.get(i);
            Validator.validateTrue(PartitionComponents.isCompatibleClass(expectedPartitionComponentType, currentPartitionComponentType), "The type '%s' of partition key component '%s' for querying on entity '%s' is not valid. It should be '%s'", currentPartitionComponentType.getCanonicalName(), partitionKeyComponent, className, expectedPartitionComponentType.getCanonicalName());
        }
    }

    void validatePartitionComponentsIn(String className, Object ... partitionComponentsInArray) {
        List<Class<?>> componentClasses = this.getComponentClasses();
        Validator.validateTrue(ArrayUtils.isNotEmpty((Object[])partitionComponentsInArray), "There should be at least one partition key component IN provided for querying on entity '%s'", className);
        List<Object> partitionComponentsIn = Arrays.asList(partitionComponentsInArray);
        log.trace("Validate partition components IN {} for slice query on entity class {}", partitionComponentsIn, (Object)className);
        Class<?> lastPartitionComponentType = componentClasses.get(componentClasses.size() - 1);
        for (int i = 0; i < partitionComponentsIn.size(); ++i) {
            Object partitionKeyComponent = partitionComponentsIn.get(i);
            Validator.validateNotNull(partitionKeyComponent, "The '%sth' partition key component IN should not be null", i + 1);
            Class<?> currentPartitionComponentType = partitionKeyComponent.getClass();
            Validator.validateTrue(PartitionComponents.isCompatibleClass(lastPartitionComponentType, currentPartitionComponentType), "The type '%s' of partition key component '%s' for querying on entity '%s' is not valid. It should be '%s'", currentPartitionComponentType.getCanonicalName(), partitionKeyComponent, className, lastPartitionComponentType.getCanonicalName());
        }
    }
}

