/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.codec;

import info.archinnov.achilles.codec.Codec;
import info.archinnov.achilles.exception.AchillesTranscodingException;
import java.util.List;

public class EnumOrdinalCodec<ENUM>
implements Codec<ENUM, Integer> {
    private final List<ENUM> enumValues;
    private final Class<ENUM> sourceType;

    public EnumOrdinalCodec(List<ENUM> enumValues, Class<ENUM> sourceType) {
        this.enumValues = enumValues;
        this.sourceType = sourceType;
    }

    public Class<ENUM> sourceType() {
        return this.sourceType;
    }

    public Class<Integer> targetType() {
        return Integer.class;
    }

    public Integer encode(ENUM fromJava) {
        if (fromJava == null) {
            return null;
        }
        if (!fromJava.getClass().isEnum()) {
            throw new AchillesTranscodingException(String.format("Object '%s' to be encoded should be an enum", fromJava));
        }
        for (int i = 0; i < this.enumValues.size(); ++i) {
            if (this.enumValues.get(i) != fromJava) continue;
            return i;
        }
        throw new AchillesTranscodingException(String.format("Cannot find matching enum values for '%s' from possible enum constants '%s' ", fromJava, this.enumValues));
    }

    public ENUM decode(Integer fromCassandra) {
        if (fromCassandra == null) {
            return null;
        }
        if (fromCassandra > this.enumValues.size() - 1 || fromCassandra < 0) {
            throw new AchillesTranscodingException(String.format("Cannot find matching enum values for '%s' from possible enum constants '%s' ", fromCassandra, this.enumValues));
        }
        return this.enumValues.get(fromCassandra);
    }

    public static <TYPE> EnumOrdinalCodec<TYPE> create(List<TYPE> enumValues, Class<TYPE> sourceType) {
        return new EnumOrdinalCodec<TYPE>(enumValues, sourceType);
    }
}

