/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.codec;

import info.archinnov.achilles.codec.Codec;
import info.archinnov.achilles.exception.AchillesTranscodingException;
import java.util.List;

public class EnumNameCodec<ENUM>
implements Codec<ENUM, String> {
    private final List<ENUM> enumValues;
    private final Class<ENUM> sourceType;

    public EnumNameCodec(List<ENUM> enumValues, Class<ENUM> sourceType) {
        this.enumValues = enumValues;
        this.sourceType = sourceType;
    }

    public Class<ENUM> sourceType() {
        return this.sourceType;
    }

    public Class<String> targetType() {
        return String.class;
    }

    public String encode(ENUM fromJava) throws AchillesTranscodingException {
        if (fromJava == null) {
            return null;
        }
        if (!fromJava.getClass().isEnum()) {
            throw new AchillesTranscodingException(String.format("Object '%s' to be encoded should be an enum", fromJava));
        }
        if (!this.enumValues.contains(fromJava)) {
            throw new AchillesTranscodingException(String.format("Cannot find matching enum values for '%s' from possible enum constants '%s' ", fromJava, this.enumValues));
        }
        return ((Enum)fromJava).name();
    }

    public ENUM decode(String fromCassandra) throws AchillesTranscodingException {
        if (fromCassandra == null) {
            return null;
        }
        for (ENUM enumValue : this.enumValues) {
            if (!((Enum)enumValue).name().equals(fromCassandra)) continue;
            return enumValue;
        }
        throw new AchillesTranscodingException(String.format("Cannot find matching enum values for '%s' from possible enum constants '%s' ", fromCassandra, this.enumValues));
    }

    public static <TYPE> EnumNameCodec<TYPE> create(List<TYPE> enumTypes, Class<TYPE> sourceType) {
        return new EnumNameCodec<TYPE>(enumTypes, sourceType);
    }
}

