/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.codec;

import info.archinnov.achilles.codec.Codec;
import info.archinnov.achilles.exception.AchillesTranscodingException;
import java.nio.ByteBuffer;

public class ByteCodec
implements Codec<Byte, ByteBuffer> {
    public Class<Byte> sourceType() {
        return Byte.class;
    }

    public Class<ByteBuffer> targetType() {
        return ByteBuffer.class;
    }

    public ByteBuffer encode(Byte fromJava) throws AchillesTranscodingException {
        if (fromJava == null) {
            return null;
        }
        return ByteBuffer.wrap(new byte[]{fromJava});
    }

    public Byte decode(ByteBuffer fromCassandra) throws AchillesTranscodingException {
        if (fromCassandra == null) {
            return null;
        }
        byte[] byteBuffer = this.readByteBuffer(fromCassandra);
        if (byteBuffer.length < 1) {
            throw new AchillesTranscodingException("Error while decoding value '" + fromCassandra + "' to type 'byte' ");
        }
        return byteBuffer[0];
    }

    private byte[] readByteBuffer(Object fromCassandra) {
        ByteBuffer byteBuffer = (ByteBuffer)fromCassandra;
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        return bytes;
    }
}

