/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.codec;

import info.archinnov.achilles.codec.Codec;
import info.archinnov.achilles.exception.AchillesTranscodingException;
import java.nio.ByteBuffer;

public class ByteArrayCodec
implements Codec<Byte[], ByteBuffer> {
    public Class<Byte[]> sourceType() {
        return Byte[].class;
    }

    public Class<ByteBuffer> targetType() {
        return ByteBuffer.class;
    }

    public ByteBuffer encode(Byte[] fromJava) throws AchillesTranscodingException {
        if (fromJava == null) {
            return null;
        }
        byte[] bytesPrimitive = new byte[fromJava.length];
        int i = 0;
        Byte[] byteArray = fromJava;
        int n = byteArray.length;
        for (int j = 0; j < n; ++j) {
            byte b = byteArray[j];
            bytesPrimitive[i++] = b;
        }
        return ByteBuffer.wrap(bytesPrimitive);
    }

    public Byte[] decode(ByteBuffer fromCassandra) {
        if (fromCassandra == null) {
            return null;
        }
        return this.readByteBuffer(fromCassandra);
    }

    private Byte[] readByteBuffer(Object fromCassandra) {
        ByteBuffer byteBuffer = (ByteBuffer)fromCassandra;
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        Byte[] byteObjects = new Byte[bytes.length];
        int i = 0;
        for (byte b : bytes) {
            byteObjects[i++] = b;
        }
        return byteObjects;
    }
}

