/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.context;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.ResultSet;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.internal.context.AbstractFlushContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.Empty;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmediateFlushContext
extends AbstractFlushContext {
    private static final Logger log = LoggerFactory.getLogger(ImmediateFlushContext.class);

    public ImmediateFlushContext(DaoContext daoContext, ConsistencyLevel consistencyLevel, Optional<com.datastax.driver.core.ConsistencyLevel> serialConsistencyLevel) {
        super(daoContext, consistencyLevel, serialConsistencyLevel);
    }

    private ImmediateFlushContext(DaoContext daoContext, List<AbstractStatementWrapper> statementWrappers, ConsistencyLevel consistencyLevel, Optional<com.datastax.driver.core.ConsistencyLevel> serialConsistencyLevel) {
        super(daoContext, statementWrappers, consistencyLevel, serialConsistencyLevel);
    }

    @Override
    public void startBatch() {
        throw new UnsupportedOperationException("Cannot start a batch with a normal PersistenceManager. Please create a Batch instead");
    }

    @Override
    public ListenableFuture<Empty> flushBatch() {
        throw new UnsupportedOperationException("Cannot end a batch with a normal PersistenceManager. Please create a Batch instead");
    }

    @Override
    public ListenableFuture<List<ResultSet>> flush() {
        log.debug("Flush immediately all pending statements");
        ListenableFuture<ResultSet> resultSetFutureFields = this.executeBatch(BatchStatement.Type.UNLOGGED, this.statementWrappers);
        ListenableFuture<ResultSet> resultSetFutureCounters = this.executeBatch(BatchStatement.Type.COUNTER, this.counterStatementWrappers);
        ImmutableList resultSetFutures = FluentIterable.from(Arrays.asList(resultSetFutureFields, resultSetFutureCounters)).filter(Predicates.not((Predicate)Predicates.isNull())).toList();
        return this.asyncUtils.mergeResultSetFutures((List<ListenableFuture<ResultSet>>)resultSetFutures);
    }

    @Override
    public AbstractFlushContext.FlushType type() {
        return AbstractFlushContext.FlushType.IMMEDIATE;
    }

    @Override
    public ImmediateFlushContext duplicate() {
        log.trace("Duplicate immediate flushing context");
        return new ImmediateFlushContext(this.daoContext, this.statementWrappers, this.consistencyLevel, (Optional<com.datastax.driver.core.ConsistencyLevel>)this.serialConsistencyLevel);
    }

    @Override
    public void triggerInterceptor(EntityMeta meta, Object entity, Event event) {
        meta.forInterception().intercept(entity, event);
    }
}

