/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.internet.AddressException;

public class NewsAddress
extends Address {
    private static final String _separator = ",";
    private static final NewsAddress[] NEWSADDRESS_ARRAY = new NewsAddress[0];
    protected String host;
    protected String newsgroup;

    public static NewsAddress[] parse(String addresses) throws AddressException {
        LinkedList<NewsAddress> result = new LinkedList<NewsAddress>();
        StringTokenizer tokenizer = new StringTokenizer(addresses, _separator);
        while (tokenizer.hasMoreTokens()) {
            String address = tokenizer.nextToken();
            result.add(new NewsAddress(address));
        }
        return result.toArray(NEWSADDRESS_ARRAY);
    }

    public static String toString(Address[] addresses) {
        StringBuffer result = new StringBuffer();
        for (int a = 0; a < addresses.length; ++a) {
            result.append(addresses[a].toString());
            if (a <= 0) continue;
            result.append(_separator);
        }
        return result.toString();
    }

    public NewsAddress() {
    }

    public NewsAddress(String newsgroup) {
        this.setNewsgroup(newsgroup);
    }

    public NewsAddress(String newsgroup, String host) {
        this.setNewsgroup(newsgroup);
        this.setHost(host);
    }

    public String getHost() {
        return this.host;
    }

    public String getNewsgroup() {
        return this.newsgroup;
    }

    public String getType() {
        return "news";
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setNewsgroup(String newsgroup) {
        int at = (newsgroup = newsgroup.trim()).indexOf("@");
        if (at != -1) {
            this.newsgroup = newsgroup.substring(0, at);
            this.host = newsgroup.substring(at + 1);
        } else {
            this.newsgroup = newsgroup;
        }
    }

    public String toString() {
        return this.newsgroup + (this.host == null ? "" : "@" + this.host);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NewsAddress)) {
            return false;
        }
        NewsAddress newsAddress = (NewsAddress)o;
        if (!this.host.equals(newsAddress.host)) {
            return false;
        }
        return this.newsgroup.equals(newsAddress.newsgroup);
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 29 * result + this.newsgroup.hashCode();
        return result;
    }
}

