/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeUtility;

public class InternetAddress
extends Address
implements Cloneable {
    private static final InternetAddress[] IA_ARRAY = new InternetAddress[0];
    protected String address;
    protected String encodedPersonal;
    protected String personal;

    public static InternetAddress getLocalAddress(Session session) {
        try {
            Properties properties = session.getProperties();
            String mailFrom = properties.getProperty("mail.from");
            if (mailFrom == null) {
                String mailUser = properties.getProperty("mail.user");
                String mailHost = properties.getProperty("mail.host");
                if (mailUser == null) {
                    mailUser = System.getProperty("user.name");
                }
                if (mailHost == null) {
                    try {
                        mailHost = InetAddress.getLocalHost().getHostName();
                    }
                    catch (SecurityException e) {
                        mailHost = "localhost";
                    }
                }
                return new InternetAddress(mailUser + "@" + mailHost);
            }
            return new InternetAddress(mailFrom);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static InternetAddress[] parse(String address) throws AddressException {
        return InternetAddress.parse(address, true);
    }

    public static InternetAddress[] parse(String addresses, boolean strict) throws AddressException {
        LinkedList<InternetAddress> result = new LinkedList<InternetAddress>();
        StringTokenizer tokenizer = new StringTokenizer(addresses, ",");
        while (tokenizer.hasMoreTokens()) {
            String address = tokenizer.nextToken();
            result.add(new InternetAddress(address));
        }
        return result.toArray(IA_ARRAY);
    }

    public static InternetAddress[] parseHeader(String addresses, boolean strict) throws AddressException {
        return InternetAddress.parse(addresses, strict);
    }

    public static String toString(Address[] addresses) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (int a = 0; a < addresses.length; ++a) {
            Address address = addresses[a];
            if (first) {
                first = false;
            } else {
                result.append(",");
            }
            result.append(address.toString());
        }
        return result.toString();
    }

    public static String toString(Address[] addresses, int used) {
        String result = InternetAddress.toString(addresses);
        if (result.length() > used) {
            // empty if block
        }
        return result;
    }

    public InternetAddress() {
    }

    public InternetAddress(String address) throws AddressException {
        int lt = address.indexOf("<");
        int gt = address.indexOf(">");
        if (lt != -1 && gt != -1) {
            this.setAddress(address.substring(lt + 1, gt));
            try {
                this.setPersonal((address.substring(0, lt) + address.substring(gt + 1)).trim());
            }
            catch (UnsupportedEncodingException e) {
                throw new AddressException(e.getMessage());
            }
        } else {
            this.setAddress(address);
        }
    }

    public InternetAddress(String address, boolean strict) throws AddressException {
    }

    public InternetAddress(String address, String personal) throws UnsupportedEncodingException {
        this(address, personal, MimeUtility.getDefaultJavaCharset());
    }

    public InternetAddress(String address, String personal, String charset) throws UnsupportedEncodingException {
        this.address = address;
        this.personal = personal;
    }

    public Object clone() {
        InternetAddress ia = new InternetAddress();
        ia.address = this.address;
        ia.personal = this.personal;
        ia.encodedPersonal = this.encodedPersonal;
        return ia;
    }

    public String getAddress() {
        return this.address;
    }

    public InternetAddress[] getGroup(boolean strict) throws AddressException {
        return null;
    }

    public String getPersonal() {
        return this.personal;
    }

    public String getType() {
        return "rfc822";
    }

    public boolean isGroup() {
        return false;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPersonal(String name) throws UnsupportedEncodingException {
        this.setPersonal(name, null);
    }

    public void setPersonal(String name, String encoding) throws UnsupportedEncodingException {
        this.encodedPersonal = MimeUtility.encodeText(name, MimeUtility.getDefaultJavaCharset(), encoding);
        this.personal = name;
    }

    public String toString() {
        return this.encodedPersonal + " <" + this.address + ">";
    }

    public String toUnicodeString() {
        return this.personal + " <" + this.address + ">";
    }

    public void validate() throws AddressException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternetAddress)) {
            return false;
        }
        InternetAddress internetAddress = (InternetAddress)o;
        if (!this.address.equals(internetAddress.address)) {
            return false;
        }
        return this.personal.equals(internetAddress.personal);
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 29 * result + this.personal.hashCode();
        return result;
    }
}

