/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.json;

import com.xiaoleilu.hutool.bean.BeanUtil;
import com.xiaoleilu.hutool.bean.copier.CopyOptions;
import com.xiaoleilu.hutool.bean.copier.ValueProvider;
import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.convert.ConvertException;
import com.xiaoleilu.hutool.convert.ConverterRegistry;
import com.xiaoleilu.hutool.convert.impl.CollectionConverter;
import com.xiaoleilu.hutool.json.JSON;
import com.xiaoleilu.hutool.json.JSONArray;
import com.xiaoleilu.hutool.json.JSONException;
import com.xiaoleilu.hutool.json.JSONNull;
import com.xiaoleilu.hutool.json.JSONObject;
import com.xiaoleilu.hutool.json.JSONString;
import com.xiaoleilu.hutool.json.JSONUtil;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.NumberUtil;
import com.xiaoleilu.hutool.util.ObjectUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import com.xiaoleilu.hutool.util.TypeUtil;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

final class InternalJSONUtil {
    private InternalJSONUtil() {
    }

    protected static final Writer writeValue(Writer writer, Object value, int indentFactor, int indent) throws JSONException, IOException {
        if (value == null || value instanceof JSONNull) {
            writer.write("null");
        } else if (value instanceof JSON) {
            ((JSON)value).write(writer, indentFactor, indent);
        } else if (value instanceof Map) {
            new JSONObject((Map)value).write(writer, indentFactor, indent);
        } else if (value instanceof Collection) {
            new JSONArray((Object)((Collection)value)).write(writer, indentFactor, indent);
        } else if (value.getClass().isArray()) {
            new JSONArray(value).write(writer, indentFactor, indent);
        } else if (value instanceof Number) {
            writer.write(NumberUtil.toStr((Number)value));
        } else if (value instanceof Boolean) {
            writer.write(value.toString());
        } else if (value instanceof JSONString) {
            String o;
            try {
                o = ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            writer.write(o != null ? o.toString() : JSONUtil.quote(value.toString()));
        } else {
            JSONUtil.quote(value.toString(), writer);
        }
        return writer;
    }

    protected static final void indent(Writer writer, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            writer.write(32);
        }
    }

    protected static void testValidity(Object obj) throws JSONException {
        if (!ObjectUtil.isValidIfNumber(obj)) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    protected static String valueToString(Object value) throws JSONException {
        if (value == null || value instanceof JSONNull) {
            return "null";
        }
        if (value instanceof JSONString) {
            try {
                return ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
        }
        if (value instanceof Number) {
            return NumberUtil.toStr((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return new JSONObject(map).toString();
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return new JSONArray((Object)coll).toString();
        }
        if (value.getClass().isArray()) {
            return new JSONArray(value).toString();
        }
        return JSONUtil.quote(value.toString());
    }

    protected static Object stringToValue(String string) {
        if (null == string || "null".equalsIgnoreCase(string)) {
            return JSONNull.NULL;
        }
        if ("".equals(string)) {
            return string;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        char b = string.charAt(0);
        if (b >= '0' && b <= '9' || b == '-') {
            try {
                if (string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1) {
                    Double d = Double.valueOf(string);
                    if (!d.isInfinite() && !d.isNaN()) {
                        return d;
                    }
                } else {
                    Long myLong = new Long(string);
                    if (string.equals(myLong.toString())) {
                        if (myLong == (long)myLong.intValue()) {
                            return myLong.intValue();
                        }
                        return myLong;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    protected static JSONObject propertyPut(JSONObject jsonObject, Object key, Object value) {
        String keyStr = Convert.toStr(key);
        String[] path = StrUtil.split((CharSequence)keyStr, ".");
        int last = path.length - 1;
        JSONObject target = jsonObject;
        for (int i = 0; i < last; ++i) {
            String segment = path[i];
            JSONObject nextTarget = target.getJSONObject(segment);
            if (nextTarget == null) {
                nextTarget = new JSONObject();
                target.put(segment, (Object)nextTarget);
            }
            target = nextTarget;
        }
        target.put(path[last], value);
        return jsonObject;
    }

    protected static <T> T toBean(final JSONObject jsonObject, T bean, final boolean ignoreError) {
        return BeanUtil.fillBean(bean, new ValueProvider<String>(){

            @Override
            public Object value(String key, Type valueType) {
                return InternalJSONUtil.jsonConvert(valueType, jsonObject.get(key), ignoreError);
            }

            @Override
            public boolean containsKey(String key) {
                return jsonObject.containsKey(key);
            }
        }, CopyOptions.create().setIgnoreCase(true).setIgnoreError(ignoreError));
    }

    protected static Object[] toArray(JSONArray jsonArray, Class<?> arrayClass, boolean ignoreError) {
        Class<?> componentType = arrayClass.isArray() ? arrayClass.getComponentType() : arrayClass;
        Object[] objArray = ArrayUtil.newArray(componentType, jsonArray.size());
        for (int i = 0; i < objArray.length; ++i) {
            objArray[i] = InternalJSONUtil.jsonConvert(componentType, jsonArray.get(i), ignoreError);
        }
        return objArray;
    }

    protected static Object jsonConvert(Type type, Object value, boolean ignoreError) throws ConvertException {
        if (null == value) {
            return null;
        }
        if (value instanceof JSONNull) {
            return null;
        }
        Class<?> rowType = TypeUtil.getClass(type);
        if (null == rowType) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Can not know Class of Type {} !", type));
        }
        if (JSON.class.isAssignableFrom(rowType)) {
            return JSONUtil.parse(value);
        }
        Object targetValue = null;
        if (value instanceof JSONObject) {
            targetValue = ((JSONObject)value).toBean(rowType, ignoreError);
        } else if (value instanceof JSONArray) {
            targetValue = rowType.isArray() ? ((JSONArray)value).toArray(rowType, ignoreError) : new CollectionConverter(rowType, TypeUtil.getTypeArgument(type)).convert(value, null);
        }
        if (null == targetValue) {
            try {
                targetValue = ConverterRegistry.getInstance().convert(rowType, value);
            }
            catch (ConvertException e) {
                if (ignoreError) {
                    return null;
                }
                throw e;
            }
        }
        if (null == targetValue && !ignoreError) {
            if (value instanceof CharSequence && StrUtil.isBlank((CharSequence)value)) {
                return null;
            }
            throw new ConvertException("Can not convert [{}] to type [{}]", value, rowType.getName());
        }
        return targetValue;
    }
}

