/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.db.AbstractSqlRunner;
import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.SqlConnRunner;
import com.xiaoleilu.hutool.db.dialect.Dialect;
import com.xiaoleilu.hutool.db.dialect.DialectFactory;
import com.xiaoleilu.hutool.db.ds.DSFactory;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class SqlRunner
extends AbstractSqlRunner {
    private DataSource ds;

    public static SqlRunner create() {
        return SqlRunner.create(DSFactory.get());
    }

    public static SqlRunner create(DataSource ds) {
        return ds == null ? null : new SqlRunner(ds);
    }

    public static SqlRunner create(DataSource ds, Dialect dialect) {
        return new SqlRunner(ds, dialect);
    }

    public static SqlRunner create(DataSource ds, String driverClassName) {
        return new SqlRunner(ds, DialectFactory.newDialect(driverClassName));
    }

    public SqlRunner(DataSource ds) {
        this(ds, DialectFactory.newDialect(ds));
    }

    public SqlRunner(DataSource ds, Dialect dialect) {
        this.runner = new SqlConnRunner(dialect);
        this.ds = ds;
    }

    public SqlRunner(DataSource ds, String driverClassName) {
        this.runner = new SqlConnRunner(driverClassName);
        this.ds = ds;
    }

    @Override
    public SqlConnRunner getRunner() {
        return this.runner;
    }

    @Override
    public void setRunner(SqlConnRunner runner) {
        this.runner = runner;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    @Override
    public void closeConnection(Connection conn) {
        DbUtil.close(conn);
    }
}

