/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.collection;

import com.xiaoleilu.hutool.bean.BeanUtil;
import com.xiaoleilu.hutool.collection.ArrayIterator;
import com.xiaoleilu.hutool.collection.BoundedPriorityQueue;
import com.xiaoleilu.hutool.collection.EnumerationIterator;
import com.xiaoleilu.hutool.collection.IterUtil;
import com.xiaoleilu.hutool.collection.IteratorEnumeration;
import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.convert.ConverterRegistry;
import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.lang.Editor;
import com.xiaoleilu.hutool.lang.Filter;
import com.xiaoleilu.hutool.lang.Matcher;
import com.xiaoleilu.hutool.map.MapUtil;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.ClassUtil;
import com.xiaoleilu.hutool.util.ObjectUtil;
import com.xiaoleilu.hutool.util.PageUtil;
import com.xiaoleilu.hutool.util.ReflectUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import com.xiaoleilu.hutool.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;

public class CollUtil {
    public static <T> Collection<T> union(Collection<T> coll1, Collection<T> coll2) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (CollUtil.isEmpty(coll1)) {
            list.addAll(coll2);
        } else if (CollUtil.isEmpty(coll2)) {
            list.addAll(coll1);
        } else {
            Map<T, Integer> map1 = CollUtil.countMap(coll1);
            Map<T, Integer> map2 = CollUtil.countMap(coll2);
            HashSet<T> elts = CollUtil.newHashSet(coll2);
            elts.addAll(coll1);
            for (Object t : elts) {
                int m = Math.max(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0));
                for (int i = 0; i < m; ++i) {
                    list.add(t);
                }
            }
        }
        return list;
    }

    @SafeVarargs
    public static <T> Collection<T> union(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        Collection<T> union = CollUtil.union(coll1, coll2);
        for (Collection<T> coll : otherColls) {
            union = CollUtil.union(union, coll);
        }
        return union;
    }

    public static <T> Collection<T> intersection(Collection<T> coll1, Collection<T> coll2) {
        ArrayList list = new ArrayList();
        if (CollUtil.isNotEmpty(coll1) && CollUtil.isNotEmpty(coll2)) {
            Map<T, Integer> map1 = CollUtil.countMap(coll1);
            Map<T, Integer> map2 = CollUtil.countMap(coll2);
            HashSet elts = CollUtil.newHashSet(coll2);
            for (Object t : elts) {
                int m = Math.min(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0));
                for (int i = 0; i < m; ++i) {
                    list.add(t);
                }
            }
        }
        return list;
    }

    @SafeVarargs
    public static <T> Collection<T> intersection(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        Collection<T> intersection = CollUtil.intersection(coll1, coll2);
        if (CollUtil.isEmpty(intersection)) {
            return intersection;
        }
        for (Collection<T> coll : otherColls) {
            if (!CollUtil.isEmpty(intersection = CollUtil.intersection(intersection, coll))) continue;
            return intersection;
        }
        return intersection;
    }

    public static <T> Collection<T> disjunction(Collection<T> coll1, Collection<T> coll2) {
        ArrayList list = new ArrayList();
        if (CollUtil.isNotEmpty(coll1) && CollUtil.isNotEmpty(coll2)) {
            Map<T, Integer> map1 = CollUtil.countMap(coll1);
            Map<T, Integer> map2 = CollUtil.countMap(coll2);
            HashSet<T> elts = CollUtil.newHashSet(coll2);
            elts.addAll(coll1);
            for (Object t : elts) {
                int m = Math.abs(Convert.toInt(map1.get(t), 0) - Convert.toInt(map2.get(t), 0));
                for (int i = 0; i < m; ++i) {
                    list.add(t);
                }
            }
        }
        return list;
    }

    public static boolean containsAny(Collection<?> coll1, Collection<?> coll2) {
        if (CollUtil.isEmpty(coll1) || CollUtil.isEmpty(coll2)) {
            return false;
        }
        if (coll1.size() < coll2.size()) {
            for (Object object : coll1) {
                if (!coll2.contains(object)) continue;
                return true;
            }
        } else {
            for (Object object : coll2) {
                if (!coll1.contains(object)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> Map<T, Integer> countMap(Iterable<T> collection) {
        return IterUtil.countMap(collection);
    }

    public static <T> String join(Iterable<T> iterable, CharSequence conjunction) {
        return IterUtil.join(iterable, conjunction);
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction) {
        return IterUtil.join(iterator, conjunction);
    }

    public static <T> List<T> popPart(Stack<T> surplusAlaDatas, int partSize) {
        if (CollUtil.isEmpty(surplusAlaDatas)) {
            return null;
        }
        ArrayList<T> currentAlaDatas = new ArrayList<T>();
        int size = surplusAlaDatas.size();
        if (size > partSize) {
            for (int i = 0; i < partSize; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        }
        return currentAlaDatas;
    }

    public static <T> List<T> popPart(Deque<T> surplusAlaDatas, int partSize) {
        if (CollUtil.isEmpty(surplusAlaDatas)) {
            return null;
        }
        ArrayList<T> currentAlaDatas = new ArrayList<T>();
        int size = surplusAlaDatas.size();
        if (size > partSize) {
            for (int i = 0; i < partSize; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        }
        return currentAlaDatas;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return MapUtil.newHashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isOrder) {
        return MapUtil.newHashMap(size, isOrder);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapUtil.newHashMap(size);
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... ts) {
        return CollUtil.newHashSet(false, ts);
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(boolean isSorted, T ... ts) {
        if (null == ts) {
            return isSorted ? new LinkedHashSet() : new HashSet();
        }
        int initialCapacity = Math.max((int)((float)ts.length / 0.75f) + 1, 16);
        HashSet set = isSorted ? new LinkedHashSet(initialCapacity) : new HashSet(initialCapacity);
        for (T t : ts) {
            set.add(t);
        }
        return set;
    }

    public static <T> HashSet<T> newHashSet(Collection<T> collection) {
        return CollUtil.newHashSet(false, collection);
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Collection<T> collection) {
        return isSorted ? new LinkedHashSet<T>(collection) : new HashSet<T>(collection);
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Iterator<T> iter) {
        HashSet set;
        if (null == iter) {
            return CollUtil.newHashSet(isSorted, (Object[])null);
        }
        HashSet hashSet = set = isSorted ? new LinkedHashSet() : new HashSet();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return set;
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Enumeration<T> enumration) {
        HashSet set;
        if (null == enumration) {
            return CollUtil.newHashSet(isSorted, (Object[])null);
        }
        HashSet hashSet = set = isSorted ? new LinkedHashSet() : new HashSet();
        while (enumration.hasMoreElements()) {
            set.add(enumration.nextElement());
        }
        return set;
    }

    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(T ... values) {
        if (null == values) {
            return new ArrayList();
        }
        ArrayList<T> arrayList = new ArrayList<T>(values.length);
        for (T t : values) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T> ArrayList<T> newArrayList(Collection<T> collection) {
        if (null == collection) {
            return new ArrayList();
        }
        return new ArrayList<T>(collection);
    }

    public static <T> ArrayList<T> newArrayList(Iterable<T> iterable) {
        return null == iterable ? new ArrayList() : CollUtil.newArrayList(iterable.iterator());
    }

    public static <T> ArrayList<T> newArrayList(Iterator<T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        if (null == iter) {
            return list;
        }
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static <T> ArrayList<T> newArrayList(Enumeration<T> enumration) {
        ArrayList<T> list = new ArrayList<T>();
        if (null == enumration) {
            return list;
        }
        while (enumration.hasMoreElements()) {
            list.add(enumration.nextElement());
        }
        return list;
    }

    public static <T> CopyOnWriteArrayList<T> newCopyOnWriteArrayList(Collection<T> collection) {
        return null == collection ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList<T>(collection);
    }

    public static <T> BlockingQueue<T> newBlockingQueue(int capacity, boolean isLinked) {
        AbstractQueue queue = isLinked ? new LinkedBlockingDeque(capacity) : new ArrayBlockingQueue(capacity);
        return queue;
    }

    public static <T> Collection<T> create(Class<?> collectionType) {
        Collection<Object> list = null;
        if (collectionType.isAssignableFrom(AbstractCollection.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (collectionType.isAssignableFrom(LinkedHashSet.class)) {
            list = new LinkedHashSet();
        } else if (collectionType.isAssignableFrom(TreeSet.class)) {
            list = new TreeSet();
        } else if (collectionType.isAssignableFrom(EnumSet.class)) {
            list = EnumSet.noneOf(ClassUtil.getTypeArgument(collectionType));
        } else if (collectionType.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(LinkedList.class)) {
            list = new LinkedList();
        } else {
            try {
                list = (Collection)ReflectUtil.newInstance(collectionType, new Object[0]);
            }
            catch (Exception e) {
                throw new UtilException(e);
            }
        }
        return list;
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType) {
        return MapUtil.createMap(mapType);
    }

    public static <T> ArrayList<T> distinct(Collection<T> collection) {
        if (CollUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        if (collection instanceof Set) {
            return new ArrayList<T>(collection);
        }
        return new ArrayList<T>(new LinkedHashSet<T>(collection));
    }

    public static <T> List<T> sub(List<T> list, int start, int end) {
        int size;
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > (size = list.size())) {
            if (start >= size) {
                return null;
            }
            end = size;
        }
        return list.subList(start, end);
    }

    public static <T> List<T> sub(Collection<T> list, int start, int end) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return CollUtil.sub(new ArrayList<T>(list), start, end);
    }

    public static <T> List<List<T>> split(Collection<T> collection, int size) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        ArrayList<T> subList = new ArrayList<T>(size);
        for (T t : collection) {
            if (subList.size() >= size) {
                result.add(subList);
                subList = new ArrayList(size);
            }
            subList.add(t);
        }
        result.add(subList);
        return result;
    }

    public static <T> Collection<T> filter(Collection<T> collection, Editor<T> editor) {
        Collection<T> collection2 = ObjectUtil.clone(collection);
        try {
            collection2.clear();
        }
        catch (UnsupportedOperationException e) {
            collection2 = new ArrayList<T>();
        }
        for (T t : collection) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            collection2.add(modified);
        }
        return collection2;
    }

    public static <T> Collection<T> filter(Collection<T> collection, Filter<T> filter) {
        Collection<T> collection2 = ObjectUtil.clone(collection);
        try {
            collection2.clear();
        }
        catch (UnsupportedOperationException e) {
            collection2 = new ArrayList<T>();
        }
        for (T t : collection) {
            if (!filter.accept(t)) continue;
            collection2.add(t);
        }
        return collection2;
    }

    public static <T> Collection<T> removeNull(Collection<T> collection) {
        return CollUtil.filter(collection, new Editor<T>(){

            @Override
            public T edit(T t) {
                return t;
            }
        });
    }

    public static <T extends CharSequence> Collection<T> removeEmpty(Collection<T> collection) {
        return CollUtil.filter(collection, new Filter<T>(){

            @Override
            public boolean accept(T t) {
                return false == StrUtil.isEmpty(t);
            }
        });
    }

    public static <T extends CharSequence> Collection<T> removeBlank(Collection<T> collection) {
        return CollUtil.filter(collection, new Filter<T>(){

            @Override
            public boolean accept(T t) {
                return false == StrUtil.isBlank(t);
            }
        });
    }

    public static List<Object> extract(Iterable<?> collection, Editor<Object> editor) {
        ArrayList<Object> fieldValueList = new ArrayList<Object>();
        for (Object bean : collection) {
            fieldValueList.add(editor.edit(bean));
        }
        return fieldValueList;
    }

    public static List<Object> getFieldValues(Iterable<?> collection, final String fieldName) {
        return CollUtil.extract(collection, new Editor<Object>(){

            @Override
            public Object edit(Object bean) {
                if (bean instanceof Map) {
                    return ((Map)bean).get(fieldName);
                }
                return ReflectUtil.getFieldValue(bean, fieldName);
            }
        });
    }

    public static <T> T findOne(Iterable<T> collection, Filter<T> filter) {
        for (T t : collection) {
            if (!filter.accept(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> T findOneByField(Iterable<T> collection, final String fieldName, final Object fieldValue) {
        return CollUtil.findOne(collection, new Filter<T>(){

            @Override
            public boolean accept(T t) {
                if (t instanceof Map) {
                    Map map = (Map)t;
                    Object value = map.get(fieldName);
                    return ObjectUtil.equal(value, fieldValue);
                }
                Object value = ReflectUtil.getFieldValue(t, fieldName);
                return ObjectUtil.equal(value, fieldValue);
            }
        });
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Editor<Map.Entry<K, V>> editor) {
        return MapUtil.filter(map, editor);
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Filter<Map.Entry<K, V>> filter) {
        return MapUtil.filter(map, filter);
    }

    public static <T> int count(Iterable<T> iterable, Matcher<T> matcher) {
        int count = 0;
        if (null != iterable) {
            for (T t : iterable) {
                if (null != matcher && !matcher.match(t)) continue;
                ++count;
            }
        }
        return count;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return MapUtil.isEmpty(map);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return IterUtil.isEmpty(iterable);
    }

    public static boolean isEmpty(Iterator<?> Iterator2) {
        return IterUtil.isEmpty(Iterator2);
    }

    public static boolean isEmpty(Enumeration<?> enumeration) {
        return null == enumeration || false == enumeration.hasMoreElements();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return false == CollUtil.isEmpty(collection);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return MapUtil.isNotEmpty(map);
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return IterUtil.isNotEmpty(iterable);
    }

    public static boolean isNotEmpty(Iterator<?> Iterator2) {
        return IterUtil.isNotEmpty(Iterator2);
    }

    public static boolean isNotEmpty(Enumeration<?> enumeration) {
        return null != enumeration && enumeration.hasMoreElements();
    }

    public static boolean hasNull(Iterable<?> iterable) {
        return IterUtil.hasNull(iterable);
    }

    public static Map<String, String> zip(String keys, String values, String delimiter, boolean isOrder) {
        return ArrayUtil.zip(StrUtil.split((CharSequence)keys, delimiter), StrUtil.split((CharSequence)values, delimiter), isOrder);
    }

    public static Map<String, String> zip(String keys, String values, String delimiter) {
        return CollUtil.zip(keys, values, delimiter, false);
    }

    public static <K, V> Map<K, V> zip(Collection<K> keys, Collection<V> values) {
        if (CollUtil.isEmpty(keys) || CollUtil.isEmpty(values)) {
            return null;
        }
        ArrayList<K> keyList = new ArrayList<K>(keys);
        ArrayList<V> valueList = new ArrayList<V>(values);
        int size = Math.min(keys.size(), values.size());
        HashMap map = new HashMap((int)((double)size / 0.75));
        for (int i = 0; i < size; ++i) {
            map.put(keyList.get(i), valueList.get(i));
        }
        return map;
    }

    public static <K, V> HashMap<K, V> toMap(Iterable<Map.Entry<K, V>> entryIter) {
        return IterUtil.toMap(entryIter);
    }

    public static HashMap<Object, Object> toMap(Object[] array) {
        return MapUtil.of(array);
    }

    public static <T> TreeSet<T> toTreeSet(Collection<T> collection, Comparator<T> comparator) {
        TreeSet<T> treeSet = new TreeSet<T>(comparator);
        for (T t : collection) {
            treeSet.add(t);
        }
        return treeSet;
    }

    public static <E> Enumeration<E> asEnumeration(Iterator<E> iter) {
        return new IteratorEnumeration<E>(iter);
    }

    public static <E> Iterator<E> asIterator(Enumeration<E> e) {
        return IterUtil.asIterator(e);
    }

    public static <E> Iterable<E> asIterable(Iterator<E> iter) {
        return IterUtil.asIterable(iter);
    }

    public static <E> Collection<E> toCollection(Iterable<E> iterable) {
        return iterable instanceof Collection ? (ArrayList<E>)iterable : CollUtil.newArrayList(iterable.iterator());
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<? extends Map<K, V>> mapList) {
        return MapUtil.toListMap(mapList);
    }

    public static <K, V> List<Map<K, V>> toMapList(Map<K, ? extends Iterable<V>> listMap) {
        return MapUtil.toMapList(listMap);
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value) {
        return CollUtil.addAll(collection, value, TypeUtil.getTypeArgument(collection.getClass()));
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value, Type elementType) {
        Iterator iter;
        if (null == collection || null == value) {
            return collection;
        }
        if (null == elementType) {
            elementType = Object.class;
        } else {
            Class<?> elementRowType = TypeUtil.getClass((Type)elementType);
            if (elementRowType.isInstance(value) && !Iterable.class.isAssignableFrom(elementRowType)) {
                collection.add(value);
                return collection;
            }
        }
        if (value instanceof Iterator) {
            iter = (Iterator)value;
        } else if (value instanceof Iterable) {
            iter = ((Iterable)value).iterator();
        } else if (value instanceof Enumeration) {
            iter = new EnumerationIterator((Enumeration)value);
        } else if (ArrayUtil.isArray(value)) {
            iter = new ArrayIterator(value);
        } else {
            throw new UtilException("Unsupport value type [] !", value.getClass());
        }
        ConverterRegistry convert = ConverterRegistry.getInstance();
        while (iter.hasNext()) {
            try {
                collection.add(convert.convert((Type)elementType, iter.next()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Iterator<T> iterator) {
        if (null != collection && null != iterator) {
            while (iterator.hasNext()) {
                collection.add(iterator.next());
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Iterable<T> iterable) {
        return CollUtil.addAll(collection, iterable.iterator());
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Enumeration<T> enumeration) {
        if (null != collection && null != enumeration) {
            while (enumeration.hasMoreElements()) {
                collection.add(enumeration.nextElement());
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, T[] values) {
        if (null != collection && null != values) {
            for (T value : values) {
                collection.add(value);
            }
        }
        return collection;
    }

    public static <T> List<T> addAllIfNotContains(List<T> list, List<T> otherList) {
        for (T t : otherList) {
            if (list.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        return IterUtil.getFirst(iterable);
    }

    public static <T> T getFirst(Iterator<T> iterator) {
        return IterUtil.getFirst(iterator);
    }

    public static Class<?> getElementType(Iterable<?> iterable) {
        return IterUtil.getElementType(iterable);
    }

    public static Class<?> getElementType(Iterator<?> iterator) {
        return IterUtil.getElementType(iterator);
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, K ... keys) {
        ArrayList<V> values = new ArrayList<V>();
        for (K k : keys) {
            values.add(map.get(k));
        }
        return values;
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, Iterable<K> keys) {
        return CollUtil.valuesOfKeys(map, keys.iterator());
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, Iterator<K> keys) {
        ArrayList<V> values = new ArrayList<V>();
        while (keys.hasNext()) {
            values.add(map.get(keys.next()));
        }
        return values;
    }

    @SafeVarargs
    public static <T> List<T> sortPageAll(int pageNo, int numPerPage, Comparator<T> comparator, Collection<T> ... colls) {
        ArrayList<T> result = new ArrayList<T>();
        for (Collection<T> coll : colls) {
            result.addAll(coll);
        }
        Collections.sort(result, comparator);
        int resultSize = result.size();
        if (resultSize <= numPerPage) {
            return result;
        }
        int[] startEnd = PageUtil.transToStartEnd(pageNo, numPerPage);
        if (startEnd[1] > resultSize) {
            return new ArrayList();
        }
        return result.subList(startEnd[0], startEnd[1]);
    }

    @SafeVarargs
    public static <T> List<T> sortPageAll2(int pageNo, int numPerPage, Comparator<T> comparator, Collection<T> ... colls) {
        BoundedPriorityQueue<T> queue = new BoundedPriorityQueue<T>(pageNo * numPerPage, comparator);
        for (Collection<T> coll : colls) {
            queue.addAll(coll);
        }
        int resultSize = queue.size();
        if (resultSize <= numPerPage) {
            return queue.toList();
        }
        int[] startEnd = PageUtil.transToStartEnd(pageNo, numPerPage);
        if (startEnd[1] > resultSize) {
            return new ArrayList();
        }
        return queue.toList().subList(startEnd[0], startEnd[1]);
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator<? super T> comparator) {
        ArrayList<T> list = new ArrayList<T>(collection);
        Collections.sort(list, comparator);
        return list;
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> c) {
        Collections.sort(list, c);
        return list;
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> result = new TreeMap<K, V>(comparator);
        result.putAll(map);
        return result;
    }

    public static <K, V> LinkedHashMap<K, V> sortToMap(Collection<Map.Entry<K, V>> entryCollection, Comparator<Map.Entry<K, V>> comparator) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(entryCollection);
        Collections.sort(list, comparator);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V> LinkedHashMap<K, V> sortByEntry(Map<K, V> map, Comparator<Map.Entry<K, V>> comparator) {
        return CollUtil.sortToMap(map.entrySet(), comparator);
    }

    public static <K, V> List<Map.Entry<K, V>> sortEntryToList(Collection<Map.Entry<K, V>> collection) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(collection);
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                Object v1 = o1.getValue();
                Object v2 = o2.getValue();
                if (v1 instanceof Comparable) {
                    return ((Comparable)v1).compareTo(v2);
                }
                return v1.toString().compareTo(v2.toString());
            }
        });
        return list;
    }

    public static <T> void forEach(Iterator<T> iterator, Consumer<T> consumer) {
        int index = 0;
        while (iterator.hasNext()) {
            consumer.accept(iterator.next(), index);
            ++index;
        }
    }

    public static <T> void forEach(Enumeration<T> enumeration, Consumer<T> consumer) {
        int index = 0;
        while (enumeration.hasMoreElements()) {
            consumer.accept(enumeration.nextElement(), index);
            ++index;
        }
    }

    public static <K, V> void forEach(Map<K, V> map, KVConsumer<K, V> kvConsumer) {
        int index = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            kvConsumer.accept(entry.getKey(), entry.getValue(), index);
            ++index;
        }
    }

    public static <T> List<List<T>> group(Collection<T> collection, Hash<T> hash) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (CollUtil.isEmpty(collection)) {
            return result;
        }
        if (null == hash) {
            hash = new Hash<T>(){

                @Override
                public int hash(T t) {
                    return null == t ? 0 : t.hashCode();
                }
            };
        }
        for (T t : collection) {
            int index = hash.hash(t);
            if (result.size() - 1 < index) {
                while (result.size() - 1 < index) {
                    result.add(null);
                }
                result.set(index, CollUtil.newArrayList(t));
                continue;
            }
            List subList = (List)result.get(index);
            if (null == subList) {
                result.set(index, CollUtil.newArrayList(t));
                continue;
            }
            subList.add(t);
        }
        return result;
    }

    public static <T> List<List<T>> groupByField(Collection<T> collection, final String fieldName) {
        return CollUtil.group(collection, new Hash<T>(){
            private List<Object> fieldNameList = new ArrayList<Object>();

            @Override
            public int hash(T t) {
                if (null == t || !BeanUtil.isBean(t.getClass())) {
                    return 0;
                }
                Object value = ReflectUtil.getFieldValue(t, fieldName);
                int hash = this.fieldNameList.indexOf(value);
                if (hash < 0) {
                    this.fieldNameList.add(value);
                    return this.fieldNameList.size() - 1;
                }
                return hash;
            }
        });
    }

    public static interface Hash<T> {
        public int hash(T var1);
    }

    public static interface KVConsumer<K, V> {
        public void accept(K var1, V var2, int var3);
    }

    public static interface Consumer<T> {
        public void accept(T var1, int var2);
    }
}

