/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.collection.CaseInsensitiveMap;
import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.util.ClassUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.ObjectUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletRequest;

public final class BeanUtil {
    private BeanUtil() {
    }

    public static boolean isBean(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                if (method.getParameterTypes().length != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static PropertyEditor findEditor(Class<?> type) {
        return PropertyEditorManager.findEditor(type);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz).getPropertyDescriptors();
    }

    public static Map<String, PropertyDescriptor> getFieldNamePropertyDescriptorMap(Class<?> clazz) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptors = BeanUtil.getPropertyDescriptors(clazz);
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            map.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return map;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptors;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = BeanUtil.getPropertyDescriptors(clazz)) {
            if (!ObjectUtil.equal(fieldName, propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        return null;
    }

    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMap(map, ClassUtil.newInstance(beanClass), isIgnoreError);
    }

    public static <T> T mapToBeanIgnoreCase(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMapIgnoreCase(map, ClassUtil.newInstance(beanClass), isIgnoreError);
    }

    public static <T> T fillBeanWithMap(final Map<?, ?> map, T bean, boolean isIgnoreError) {
        return BeanUtil.fillBean(bean, new ValueProvider<String>(){

            @Override
            public Object value(String key, Class<?> valueType) {
                return map.get(key);
            }

            @Override
            public boolean containsKey(String key) {
                return map.containsKey(key);
            }
        }, CopyOptions.create().setIgnoreError(isIgnoreError));
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isToCamelCase, boolean isIgnoreError) {
        if (isToCamelCase) {
            HashMap map2 = new HashMap();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object key = entry.getKey();
                if (null != key && key instanceof String) {
                    String keyStr = (String)key;
                    map2.put(StrUtil.toCamelCase(keyStr), entry.getValue());
                    continue;
                }
                map2.put((String)key, entry.getValue());
            }
            return BeanUtil.fillBeanWithMap(map2, bean, isIgnoreError);
        }
        return BeanUtil.fillBeanWithMap(map, bean, isIgnoreError);
    }

    public static <T> T fillBeanWithMapIgnoreCase(Map<?, ?> map, T bean, boolean isIgnoreError) {
        final CaseInsensitiveMap caseInsensitiveMap = new CaseInsensitiveMap(map);
        return BeanUtil.fillBean(bean, new ValueProvider<String>(){

            @Override
            public Object value(String key, Class<?> valueType) {
                return caseInsensitiveMap.get(key);
            }

            @Override
            public boolean containsKey(String key) {
                return caseInsensitiveMap.containsKey(key);
            }
        }, CopyOptions.create().setIgnoreError(isIgnoreError));
    }

    public static <T> T requestParamToBean(ServletRequest request, Class<T> beanClass, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithRequestParam(request, ClassUtil.newInstance(beanClass), isIgnoreError);
    }

    public static <T> T fillBeanWithRequestParam(final ServletRequest request, T bean, boolean isIgnoreError) {
        final String beanName = StrUtil.lowerFirst(bean.getClass().getSimpleName());
        return BeanUtil.fillBean(bean, new ValueProvider<String>(){

            @Override
            public Object value(String key, Class<?> valueType) {
                String value = request.getParameter(key);
                if (StrUtil.isEmpty(value) && StrUtil.isEmpty(value = request.getParameter(beanName + "." + key))) {
                    value = null;
                }
                return value;
            }

            @Override
            public boolean containsKey(String key) {
                return null != request.getParameter(key);
            }
        }, CopyOptions.create().setIgnoreError(isIgnoreError));
    }

    public static <T> T toBean(Class<T> beanClass, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        return BeanUtil.fillBean(ClassUtil.newInstance(beanClass), valueProvider, copyOptions);
    }

    public static <T> T fillBean(T bean, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        if (null == valueProvider) {
            return bean;
        }
        Class actualEditable = bean.getClass();
        if (copyOptions.editable != null) {
            if (!copyOptions.editable.isInstance(bean)) {
                throw new IllegalArgumentException(StrUtil.format("Target class [{}] not assignable to Editable class [{}]", bean.getClass().getName(), copyOptions.editable.getName()));
            }
            actualEditable = copyOptions.editable;
        }
        HashSet<String> ignoreSet = copyOptions.ignoreProperties != null ? CollectionUtil.newHashSet(copyOptions.ignoreProperties) : null;
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor property : propertyDescriptors = BeanUtil.getPropertyDescriptors(actualEditable)) {
                Class<?> propertyType;
                Object value;
                String propertyName = property.getName();
                if (null != ignoreSet && ignoreSet.contains(propertyName) || !valueProvider.containsKey(propertyName) || null == (value = valueProvider.value(propertyName, propertyType = property.getPropertyType())) && copyOptions.ignoreNullValue) continue;
                try {
                    if (!propertyType.isInstance(value) && null == (value = Convert.convert(propertyType, value)) && copyOptions.ignoreNullValue) continue;
                    ClassUtil.setAccessible(property.getWriteMethod()).invoke(bean, value);
                }
                catch (Exception e) {
                    if (copyOptions.ignoreError) continue;
                    throw new UtilException(e, "Inject [{}] error!", property.getName());
                }
            }
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
        return bean;
    }

    public static <T> Map<String, Object> beanToMap(T bean) {
        return BeanUtil.beanToMap(bean, false, false);
    }

    public static <T> Map<String, Object> beanToMap(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (bean == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor property : propertyDescriptors = BeanUtil.getPropertyDescriptors(bean.getClass())) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(bean, new Object[0]);
                if (ignoreNullValue && null == value) continue;
                map.put(isToUnderlineCase ? StrUtil.toUnderlineCase(key) : key, value);
            }
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
        return map;
    }

    public static void copyProperties(Object source, Object target) {
        BeanUtil.copyProperties(source, target, CopyOptions.create());
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) {
        BeanUtil.copyProperties(source, target, CopyOptions.create().setIgnoreProperties(ignoreProperties));
    }

    public static void copyProperties(final Object source, Object target, CopyOptions copyOptions) {
        Map<String, PropertyDescriptor> sourcePdMap;
        if (null == copyOptions) {
            copyOptions = new CopyOptions();
        }
        final boolean ignoreError = copyOptions.ignoreError;
        try {
            sourcePdMap = BeanUtil.getFieldNamePropertyDescriptorMap(source.getClass());
        }
        catch (IntrospectionException e) {
            throw new UtilException(e);
        }
        BeanUtil.fillBean(target, new ValueProvider<String>(){

            @Override
            public Object value(String key, Class<?> valueType) {
                block3: {
                    PropertyDescriptor sourcePd = (PropertyDescriptor)sourcePdMap.get(key);
                    Method readMethod = sourcePd.getReadMethod();
                    if (readMethod != null && ClassUtil.isAssignable(valueType, readMethod.getReturnType())) {
                        try {
                            return ClassUtil.setAccessible(readMethod).invoke(source, new Object[0]);
                        }
                        catch (Exception e) {
                            if (ignoreError) break block3;
                            throw new UtilException(e, "Inject [{}] error!", key);
                        }
                    }
                }
                return null;
            }

            @Override
            public boolean containsKey(String key) {
                return sourcePdMap.containsKey(key);
            }
        }, copyOptions);
    }

    public static class CopyOptions {
        private Class<?> editable;
        private boolean ignoreNullValue;
        private String[] ignoreProperties;
        private boolean ignoreError;

        public static CopyOptions create() {
            return new CopyOptions();
        }

        public static CopyOptions create(Class<?> editable, boolean ignoreNullValue, String ... ignoreProperties) {
            return new CopyOptions(editable, ignoreNullValue, ignoreProperties);
        }

        public CopyOptions() {
        }

        public CopyOptions(Class<?> editable, boolean ignoreNullValue, String ... ignoreProperties) {
            this.editable = editable;
            this.ignoreNullValue = ignoreNullValue;
            this.ignoreProperties = ignoreProperties;
        }

        public CopyOptions setEditable(Class<?> editable) {
            this.editable = editable;
            return this;
        }

        public CopyOptions setIgnoreNullValue(boolean ignoreNullVall) {
            this.ignoreNullValue = ignoreNullVall;
            return this;
        }

        public CopyOptions setIgnoreProperties(String ... ignoreProperties) {
            this.ignoreProperties = ignoreProperties;
            return this;
        }

        public CopyOptions setIgnoreError(boolean ignoreError) {
            this.ignoreError = ignoreError;
            return this;
        }
    }

    public static interface ValueProvider<T> {
        public Object value(T var1, Class<?> var2);

        public boolean containsKey(T var1);
    }
}

