/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.log;

import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.dialect.commons.ApacheCommonsLogFactory;
import com.xiaoleilu.hutool.log.dialect.console.ConsoleLogFactory;
import com.xiaoleilu.hutool.log.dialect.jdk.JdkLogFactory;
import com.xiaoleilu.hutool.log.dialect.log4j.Log4jLogFactory;
import com.xiaoleilu.hutool.log.dialect.log4j2.Log4j2LogFactory;
import com.xiaoleilu.hutool.log.dialect.slf4j.Slf4jLogFactory;

public abstract class LogFactory {
    private String logFramworkName;
    private static volatile LogFactory currentLogFactory;
    private static final Object lock;

    public LogFactory(String logFramworkName) {
        this.logFramworkName = logFramworkName;
    }

    public abstract Log getLog(String var1);

    public abstract Log getLog(Class<?> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogFactory getCurrentLogFactory() {
        if (null == currentLogFactory) {
            Object object = lock;
            synchronized (object) {
                if (null == currentLogFactory) {
                    currentLogFactory = LogFactory.detectLogFactory();
                }
            }
        }
        return currentLogFactory;
    }

    public static LogFactory setCurrentLogFactory(Class<? extends LogFactory> logFactoryClass) {
        try {
            return LogFactory.setCurrentLogFactory(logFactoryClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not instance LogFactory class!", e);
        }
    }

    public static LogFactory setCurrentLogFactory(LogFactory logFactory) {
        logFactory.getLog(LogFactory.class).debug("Custom Use [{}] Logger.", logFactory.logFramworkName);
        currentLogFactory = logFactory;
        return currentLogFactory;
    }

    public static Log get(String name) {
        return LogFactory.getCurrentLogFactory().getLog(name);
    }

    public static Log get(Class<?> clazz) {
        return LogFactory.getCurrentLogFactory().getLog(clazz);
    }

    public static Log get() {
        return LogFactory.get(new Exception().getStackTrace()[1].getClassName());
    }

    protected static Log indirectGet() {
        return LogFactory.get(new Exception().getStackTrace()[2].getClassName());
    }

    private static LogFactory detectLogFactory() {
        LogFactory logFactory;
        try {
            logFactory = new Slf4jLogFactory(true);
            logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
        }
        catch (Throwable e) {
            try {
                logFactory = new Log4jLogFactory();
                logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
            }
            catch (Throwable e2) {
                try {
                    logFactory = new Log4j2LogFactory();
                    logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
                }
                catch (Throwable e3) {
                    try {
                        logFactory = new ApacheCommonsLogFactory();
                        logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
                    }
                    catch (Throwable e4) {
                        try {
                            logFactory = new JdkLogFactory();
                            logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
                        }
                        catch (Throwable e5) {
                            logFactory = new ConsoleLogFactory();
                            logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
                        }
                    }
                }
            }
        }
        return logFactory;
    }

    static {
        lock = new Object();
    }
}

