/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.io.resource;

import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IORuntimeException;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.util.URLUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;

public class UrlResource {
    protected URL url;

    public UrlResource(URL url) {
        this.url = url;
    }

    public UrlResource(File file) {
        this.url = URLUtil.getURL(file);
    }

    public final URL getUrl() {
        return this.url;
    }

    public InputStream getStream() {
        if (null == this.url) {
            throw new IORuntimeException("Resource [{}] not exist!", this.url);
        }
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public BufferedReader getReader(Charset charset) {
        return IoUtil.getReader(this.getStream(), charset);
    }

    public File getFile() {
        return FileUtil.file(this.url);
    }

    public String toString() {
        return null == this.url ? "null" : this.url.toString();
    }
}

