/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.http;

import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.http.HttpException;
import com.xiaoleilu.hutool.http.HttpRequest;
import com.xiaoleilu.hutool.io.FastByteArrayOutputStream;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.io.StreamProgress;
import com.xiaoleilu.hutool.log.StaticLog;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.CharsetUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.ReUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public final class HttpUtil {
    public static final Pattern CHARSET_PATTERN = Pattern.compile("charset=(.*?)\"");

    private HttpUtil() {
    }

    public static String encode(String content, Charset charset) {
        return HttpUtil.encode(content, charset.name());
    }

    public static String encode(String content, String charsetStr) {
        if (StrUtil.isBlank(content)) {
            return content;
        }
        String encodeContent = null;
        try {
            encodeContent = URLEncoder.encode(content, charsetStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpException(StrUtil.format("Unsupported encoding: [{}]", charsetStr), e);
        }
        return encodeContent;
    }

    public static String decode(String content, Charset charset) {
        return HttpUtil.decode(content, charset.name());
    }

    public static String decode(String content, String charsetStr) {
        if (StrUtil.isBlank(content)) {
            return content;
        }
        String encodeContnt = null;
        try {
            encodeContnt = URLDecoder.decode(content, charsetStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpException(StrUtil.format("Unsupported encoding: [{}]", charsetStr), e);
        }
        return encodeContnt;
    }

    public static String getClientIP(HttpServletRequest request, String ... otherHeaderNames) {
        String ip;
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtil.isNotEmpty(otherHeaderNames)) {
            headers = ArrayUtil.addAll(headers, otherHeaderNames);
        }
        for (String header : headers) {
            ip = request.getHeader(header);
            if (HttpUtil.isUnknow(ip)) continue;
            return HttpUtil.getMultistageReverseProxyIp(ip);
        }
        ip = request.getRemoteAddr();
        return HttpUtil.getMultistageReverseProxyIp(ip);
    }

    public static boolean isHttps(String url) {
        return url.toLowerCase().startsWith("https");
    }

    public static String get(String urlString, String customCharset) {
        return ((HttpRequest)HttpRequest.get(urlString).charset(customCharset)).execute().body();
    }

    public static String get(String urlString) {
        return HttpRequest.get(urlString).execute().body();
    }

    public static String get(String urlString, Map<String, Object> paramMap) {
        return HttpRequest.get(urlString).form(paramMap).execute().body();
    }

    public static String post(String urlString, Map<String, Object> paramMap) {
        return HttpRequest.post(urlString).form(paramMap).execute().body();
    }

    public static String post(String urlString, String params) {
        return HttpRequest.post(urlString).body(params).execute().body();
    }

    public static String downloadString(String url, String customCharsetName) {
        return HttpUtil.downloadString(url, CharsetUtil.charset(customCharsetName), null);
    }

    public static String downloadString(String url, Charset customCharset) {
        return HttpUtil.downloadString(url, customCharset, null);
    }

    public static String downloadString(String url, Charset customCharset, StreamProgress streamPress) {
        if (StrUtil.isBlank(url)) {
            throw new NullPointerException("[url] is null!");
        }
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        HttpUtil.download(url, out, true, streamPress);
        return null == customCharset ? out.toString() : out.toString(customCharset);
    }

    public static long downloadFile(String url, String dest) {
        return HttpUtil.downloadFile(url, FileUtil.file(dest));
    }

    public static long downloadFile(String url, File destFile) {
        return HttpUtil.downloadFile(url, destFile, null);
    }

    public static long downloadFile(String url, File destFile, StreamProgress streamProgress) {
        if (StrUtil.isBlank(url)) {
            throw new NullPointerException("[url] is null!");
        }
        if (null == destFile) {
            throw new NullPointerException("[destFile] is null!");
        }
        if (destFile.isDirectory()) {
            String fileName = StrUtil.subSuf(url, url.lastIndexOf(47) + 1);
            StaticLog.debug("FileName: {}", fileName);
            if (StrUtil.isBlank(fileName)) {
                fileName = HttpUtil.encode(url, CharsetUtil.CHARSET_UTF_8);
            }
            destFile = FileUtil.file(destFile, fileName);
        }
        BufferedOutputStream out = null;
        try {
            out = FileUtil.getOutputStream(destFile);
            return HttpUtil.download(url, out, true, streamProgress);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    public static long download(String url, OutputStream out, boolean isCloseOut) {
        return HttpUtil.download(url, out, isCloseOut, null);
    }

    public static long download(String url, OutputStream out, boolean isCloseOut, StreamProgress streamProgress) {
        long l;
        if (StrUtil.isBlank(url)) {
            throw new NullPointerException("[url] is null!");
        }
        if (null == out) {
            throw new NullPointerException("[out] is null!");
        }
        InputStream in = null;
        try {
            in = new URL(url).openStream();
            l = IoUtil.copyByNIO(in, out, 1024, streamProgress);
        }
        catch (IOException e) {
            try {
                throw new HttpException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(in);
                if (isCloseOut) {
                    IoUtil.close(out);
                }
                throw throwable;
            }
        }
        IoUtil.close(in);
        if (isCloseOut) {
            IoUtil.close(out);
        }
        return l;
    }

    public static String toParams(Map<String, Object> paramMap) {
        return HttpUtil.toParams(paramMap, CharsetUtil.CHARSET_UTF_8);
    }

    public static String toParams(Map<String, Object> paramMap, String charsetName) {
        return HttpUtil.toParams(paramMap, CharsetUtil.charset(charsetName));
    }

    public static String toParams(Map<String, Object> paramMap, Charset charset) {
        if (CollectionUtil.isEmpty(paramMap)) {
            return "";
        }
        if (null == charset) {
            charset = CharsetUtil.CHARSET_UTF_8;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, Object> item : paramMap.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("&");
            }
            sb.append(HttpUtil.encode(item.getKey(), charset)).append("=").append(HttpUtil.encode(Convert.toStr(item.getValue()), charset));
        }
        return sb.toString();
    }

    public static Map<String, List<String>> decodeParams(String paramsStr, String charset) {
        int i;
        if (StrUtil.isBlank(paramsStr)) {
            return Collections.emptyMap();
        }
        int pathEndPos = paramsStr.indexOf(63);
        if (pathEndPos > 0) {
            paramsStr = StrUtil.subSuf(paramsStr, pathEndPos + 1);
        }
        paramsStr = HttpUtil.decode(paramsStr, charset);
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        String name = null;
        int pos = 0;
        for (i = 0; i < paramsStr.length(); ++i) {
            char c = paramsStr.charAt(i);
            if (c == '=' && name == null) {
                if (pos != i) {
                    name = paramsStr.substring(pos, i);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&' && c != ';') continue;
            if (name == null && pos != i) {
                HttpUtil.addParam(params, paramsStr.substring(pos, i), "");
            } else if (name != null) {
                HttpUtil.addParam(params, name, paramsStr.substring(pos, i));
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                HttpUtil.addParam(params, paramsStr.substring(pos, i), "");
            } else {
                HttpUtil.addParam(params, name, paramsStr.substring(pos, i));
            }
        } else if (name != null) {
            HttpUtil.addParam(params, name, "");
        }
        return params;
    }

    public static String urlWithForm(String url, Map<String, Object> form) {
        String queryString = HttpUtil.toParams(form, "UTF-8");
        return HttpUtil.urlWithForm(url, queryString);
    }

    public static String urlWithForm(String url, String queryString) {
        if (StrUtil.isNotBlank(queryString)) {
            if (url.contains("?")) {
                url = url + "&" + queryString;
            }
            url = url + (url.endsWith("?") ? queryString : "?" + queryString);
        }
        return url;
    }

    public static String getCharset(HttpURLConnection conn) {
        if (conn == null) {
            return null;
        }
        String charset = ReUtil.get(CHARSET_PATTERN, conn.getContentType(), 1);
        return charset;
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (HttpUtil.isUnknow(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static boolean isUnknow(String checkString) {
        return StrUtil.isBlank(checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    public static String getString(InputStream in, String charset, boolean isGetCharsetFromContent) throws IOException {
        if (StrUtil.isBlank(charset)) {
            charset = "UTF-8";
        }
        if (!isGetCharsetFromContent) {
            return IoUtil.read(in, charset);
        }
        StringBuilder content = new StringBuilder();
        BufferedReader reader = IoUtil.getReader(in, charset);
        String line = null;
        while ((line = reader.readLine()) != null) {
            String charsetInContent;
            content.append(line).append("\n");
            if (!isGetCharsetFromContent || !StrUtil.isNotBlank(charsetInContent = ReUtil.get(CHARSET_PATTERN, line, 1))) continue;
            StaticLog.debug("Http content charset\uff1a{}", charsetInContent);
            charset = charsetInContent;
            reader = IoUtil.getReader(in, charset);
            isGetCharsetFromContent = false;
        }
        return content.toString();
    }

    public static String getMimeType(String filePath) {
        return URLConnection.getFileNameMap().getContentTypeFor(filePath);
    }

    private static boolean addParam(Map<String, List<String>> params, String name, String value) {
        List<String> values = params.get(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            params.put(name, values);
        }
        values.add(value);
        return true;
    }
}

