/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.geo;

import com.xiaoleilu.hutool.geo.BoundingBox;
import com.xiaoleilu.hutool.geo.Location;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class GeoHash
implements Comparable<GeoHash>,
Serializable {
    private static final long serialVersionUID = -8553214249630252175L;
    private static final int MAX_BIT_PRECISION = 64;
    private static final int MAX_CHARACTER_PRECISION = 12;
    private static final int[] BITS = new int[]{16, 8, 4, 2, 1};
    private static final int BASE32_BITS = 5;
    public static final long FIRST_BIT_FLAGGED = Long.MIN_VALUE;
    private static final char[] base32 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final Map<Character, Integer> decodeMap = new HashMap<Character, Integer>();
    protected long bits = 0L;
    private Location point;
    private BoundingBox boundingBox;
    protected byte significantBits = 0;

    private GeoHash() {
    }

    public static GeoHash withCharacterPrecision(double latitude, double longitude, int numberOfCharacters) {
        if (numberOfCharacters > 12) {
            throw new IllegalArgumentException("A geohash can only be 12 character long.");
        }
        return new GeoHash(latitude, longitude, numberOfCharacters * 5);
    }

    public static GeoHash withBitPrecision(double latitude, double longitude, int numberOfBits) {
        if (numberOfBits > 64) {
            throw new IllegalArgumentException("A Geohash can only be 64 bits long!");
        }
        if (Math.abs(latitude) > 90.0 || Math.abs(longitude) > 180.0) {
            throw new IllegalArgumentException("Can't have lat/lon values out of (-90,90)/(-180/180)");
        }
        return new GeoHash(latitude, longitude, numberOfBits);
    }

    public static GeoHash fromBinaryString(String binaryString) {
        GeoHash geohash = new GeoHash();
        for (int i = 0; i < binaryString.length(); ++i) {
            if (binaryString.charAt(i) == '1') {
                geohash.addOnBitToEnd();
                continue;
            }
            if (binaryString.charAt(i) == '0') {
                geohash.addOffBitToEnd();
                continue;
            }
            throw new IllegalArgumentException(binaryString + " is not a valid geohash as a binary string");
        }
        geohash.bits <<= 64 - geohash.significantBits;
        long[] latitudeBits = geohash.getRightAlignedLatitudeBits();
        long[] longitudeBits = geohash.getRightAlignedLongitudeBits();
        return geohash.recombineLatLonBitsToHash(latitudeBits, longitudeBits);
    }

    public static GeoHash fromGeohashString(String geohash) {
        double[] latitudeRange = new double[]{-90.0, 90.0};
        double[] longitudeRange = new double[]{-180.0, 180.0};
        boolean isEvenBit = true;
        GeoHash hash = new GeoHash();
        for (int i = 0; i < geohash.length(); ++i) {
            int cd = decodeMap.get(Character.valueOf(geohash.charAt(i)));
            for (int j = 0; j < 5; ++j) {
                int mask = BITS[j];
                if (isEvenBit) {
                    GeoHash.divideRangeDecode(hash, longitudeRange, (cd & mask) != 0);
                } else {
                    GeoHash.divideRangeDecode(hash, latitudeRange, (cd & mask) != 0);
                }
                isEvenBit = !isEvenBit;
            }
        }
        hash.boundingBox = new BoundingBox(latitudeRange[0], latitudeRange[1], longitudeRange[0], longitudeRange[1]);
        hash.point = hash.boundingBox.getCenterPoint();
        hash.bits <<= 64 - hash.significantBits;
        return hash;
    }

    public static GeoHash fromLongValue(long hashVal, int significantBits) {
        String binaryString = Long.toBinaryString(hashVal);
        if (binaryString.length() > significantBits) {
            binaryString = StrUtil.subPre(binaryString, significantBits);
        }
        return GeoHash.fromBinaryString(binaryString);
    }

    public static String geoHashStringWithCharacterPrecision(double latitude, double longitude, int numberOfCharacters) {
        GeoHash hash = GeoHash.withCharacterPrecision(latitude, longitude, numberOfCharacters);
        return hash.toBase32();
    }

    private GeoHash(double latitude, double longitude, int desiredPrecision) {
        this.point = new Location(latitude, longitude);
        desiredPrecision = Math.min(desiredPrecision, 64);
        boolean isEvenBit = true;
        double[] latitudeRange = new double[]{-90.0, 90.0};
        double[] longitudeRange = new double[]{-180.0, 180.0};
        while (this.significantBits < desiredPrecision) {
            if (isEvenBit) {
                this.divideRangeEncode(longitude, longitudeRange);
            } else {
                this.divideRangeEncode(latitude, latitudeRange);
            }
            isEvenBit = !isEvenBit;
        }
        this.boundingBox = new BoundingBox(latitudeRange[0], latitudeRange[1], longitudeRange[0], longitudeRange[1]);
        this.bits <<= 64 - desiredPrecision;
    }

    public GeoHash next(int step) {
        return GeoHash.fromOrd(this.ord() + (long)step, this.significantBits);
    }

    public GeoHash next() {
        return this.next(1);
    }

    public GeoHash prev() {
        return this.next(-1);
    }

    public long ord() {
        int insignificantBits = 64 - this.significantBits;
        return this.bits >>> insignificantBits;
    }

    public int getCharacterPrecision() {
        if (this.significantBits % 5 != 0) {
            throw new IllegalStateException("precision of GeoHash is not divisble by 5: " + this);
        }
        return this.significantBits / 5;
    }

    public static GeoHash fromOrd(long ord, int significantBits) {
        int insignificantBits = 64 - significantBits;
        return GeoHash.fromLongValue(ord << insignificantBits, significantBits);
    }

    public static long stepsBetween(GeoHash one, GeoHash two) {
        if (one.significantBits() != two.significantBits()) {
            throw new IllegalArgumentException("It is only valid to compare the number of steps between two hashes if they have the same number of significant bits");
        }
        return two.ord() - one.ord();
    }

    private void divideRangeEncode(double value, double[] range) {
        double mid = (range[0] + range[1]) / 2.0;
        if (value >= mid) {
            this.addOnBitToEnd();
            range[0] = mid;
        } else {
            this.addOffBitToEnd();
            range[1] = mid;
        }
    }

    private static void divideRangeDecode(GeoHash hash, double[] range, boolean b) {
        double mid = (range[0] + range[1]) / 2.0;
        if (b) {
            hash.addOnBitToEnd();
            range[0] = mid;
        } else {
            hash.addOffBitToEnd();
            range[1] = mid;
        }
    }

    public GeoHash[] getAdjacent() {
        GeoHash northern = this.getNorthernNeighbour();
        GeoHash eastern = this.getEasternNeighbour();
        GeoHash southern = this.getSouthernNeighbour();
        GeoHash western = this.getWesternNeighbour();
        return new GeoHash[]{northern, northern.getEasternNeighbour(), eastern, southern.getEasternNeighbour(), southern, southern.getWesternNeighbour(), western, northern.getWesternNeighbour()};
    }

    public int significantBits() {
        return this.significantBits;
    }

    public long longValue() {
        return this.bits;
    }

    public String toBase32() {
        if (this.significantBits % 5 != 0) {
            throw new IllegalStateException("Cannot convert a geohash to base32 if the precision is not a multiple of 5.");
        }
        StringBuilder buf = new StringBuilder();
        long firstFiveBitsMask = -576460752303423488L;
        long bitsCopy = this.bits;
        int partialChunks = (int)Math.ceil((double)this.significantBits / 5.0);
        for (int i = 0; i < partialChunks; ++i) {
            int pointer = (int)((bitsCopy & firstFiveBitsMask) >>> 59);
            buf.append(base32[pointer]);
            bitsCopy <<= 5;
        }
        return buf.toString();
    }

    public boolean within(GeoHash boundingBox) {
        return (this.bits & boundingBox.mask()) == boundingBox.bits;
    }

    public boolean contains(Location point) {
        return this.boundingBox.contains(point);
    }

    public Location getPoint() {
        return this.point;
    }

    public Location getBoundingBoxCenterPoint() {
        return this.boundingBox.getCenterPoint();
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public boolean enclosesCircleAroundPoint(Location point, double radius) {
        return false;
    }

    protected GeoHash recombineLatLonBitsToHash(long[] latBits, long[] lonBits) {
        GeoHash hash = new GeoHash();
        boolean isEvenBit = false;
        latBits[0] = latBits[0] << (int)(64L - latBits[1]);
        lonBits[0] = lonBits[0] << (int)(64L - lonBits[1]);
        double[] latitudeRange = new double[]{-90.0, 90.0};
        double[] longitudeRange = new double[]{-180.0, 180.0};
        int i = 0;
        while ((long)i < latBits[1] + lonBits[1]) {
            if (isEvenBit) {
                GeoHash.divideRangeDecode(hash, latitudeRange, (latBits[0] & Long.MIN_VALUE) == Long.MIN_VALUE);
                latBits[0] = latBits[0] << 1;
            } else {
                GeoHash.divideRangeDecode(hash, longitudeRange, (lonBits[0] & Long.MIN_VALUE) == Long.MIN_VALUE);
                lonBits[0] = lonBits[0] << 1;
            }
            isEvenBit = !isEvenBit;
            ++i;
        }
        hash.bits <<= 64 - hash.significantBits;
        this.boundingBox = new BoundingBox(latitudeRange[0], latitudeRange[1], longitudeRange[0], longitudeRange[1]);
        hash.point = hash.boundingBox.getCenterPoint();
        return hash;
    }

    public GeoHash getNorthernNeighbour() {
        long[] latitudeBits = this.getRightAlignedLatitudeBits();
        long[] longitudeBits = this.getRightAlignedLongitudeBits();
        latitudeBits[0] = latitudeBits[0] + 1L;
        latitudeBits[0] = this.maskLastNBits(latitudeBits[0], latitudeBits[1]);
        return this.recombineLatLonBitsToHash(latitudeBits, longitudeBits);
    }

    public GeoHash getSouthernNeighbour() {
        long[] latitudeBits = this.getRightAlignedLatitudeBits();
        long[] longitudeBits = this.getRightAlignedLongitudeBits();
        latitudeBits[0] = latitudeBits[0] - 1L;
        latitudeBits[0] = this.maskLastNBits(latitudeBits[0], latitudeBits[1]);
        return this.recombineLatLonBitsToHash(latitudeBits, longitudeBits);
    }

    public GeoHash getEasternNeighbour() {
        long[] latitudeBits = this.getRightAlignedLatitudeBits();
        long[] longitudeBits = this.getRightAlignedLongitudeBits();
        longitudeBits[0] = longitudeBits[0] + 1L;
        longitudeBits[0] = this.maskLastNBits(longitudeBits[0], longitudeBits[1]);
        return this.recombineLatLonBitsToHash(latitudeBits, longitudeBits);
    }

    public GeoHash getWesternNeighbour() {
        long[] latitudeBits = this.getRightAlignedLatitudeBits();
        long[] longitudeBits = this.getRightAlignedLongitudeBits();
        longitudeBits[0] = longitudeBits[0] - 1L;
        longitudeBits[0] = this.maskLastNBits(longitudeBits[0], longitudeBits[1]);
        return this.recombineLatLonBitsToHash(latitudeBits, longitudeBits);
    }

    protected long[] getRightAlignedLatitudeBits() {
        long copyOfBits = this.bits << 1;
        long value = this.extractEverySecondBit(copyOfBits, this.getNumberOfLatLonBits()[0]);
        return new long[]{value, this.getNumberOfLatLonBits()[0]};
    }

    protected long[] getRightAlignedLongitudeBits() {
        long copyOfBits = this.bits;
        long value = this.extractEverySecondBit(copyOfBits, this.getNumberOfLatLonBits()[1]);
        return new long[]{value, this.getNumberOfLatLonBits()[1]};
    }

    private long extractEverySecondBit(long copyOfBits, int numberOfBits) {
        long value = 0L;
        for (int i = 0; i < numberOfBits; ++i) {
            if ((copyOfBits & Long.MIN_VALUE) == Long.MIN_VALUE) {
                value |= 1L;
            }
            value <<= 1;
            copyOfBits <<= 2;
        }
        return value >>>= 1;
    }

    protected int[] getNumberOfLatLonBits() {
        if (this.significantBits % 2 == 0) {
            return new int[]{this.significantBits / 2, this.significantBits / 2};
        }
        return new int[]{this.significantBits / 2, this.significantBits / 2 + 1};
    }

    protected final void addOnBitToEnd() {
        this.significantBits = (byte)(this.significantBits + 1);
        this.bits <<= 1;
        this.bits |= 1L;
    }

    protected final void addOffBitToEnd() {
        this.significantBits = (byte)(this.significantBits + 1);
        this.bits <<= 1;
    }

    public String toString() {
        if (this.significantBits % 5 == 0) {
            return String.format("%s -> %s -> %s", Long.toBinaryString(this.bits), this.boundingBox, this.toBase32());
        }
        return String.format("%s -> %s, bits: %d", Long.toBinaryString(this.bits), this.boundingBox, this.significantBits);
    }

    public String toBinaryString() {
        StringBuilder bui = new StringBuilder();
        long bitsCopy = this.bits;
        for (int i = 0; i < this.significantBits; ++i) {
            if ((bitsCopy & Long.MIN_VALUE) == Long.MIN_VALUE) {
                bui.append('1');
            } else {
                bui.append('0');
            }
            bitsCopy <<= 1;
        }
        return bui.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GeoHash) {
            GeoHash other = (GeoHash)obj;
            if (other.significantBits == this.significantBits && other.bits == this.bits) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int f = 17;
        f = 31 * f + (int)(this.bits ^ this.bits >>> 32);
        f = 31 * f + this.significantBits;
        return f;
    }

    private long mask() {
        if (this.significantBits == 0) {
            return 0L;
        }
        long value = Long.MIN_VALUE;
        return value >>= this.significantBits - 1;
    }

    private long maskLastNBits(long value, long n) {
        long mask = -1L;
        return value & (mask >>>= (int)(64L - n));
    }

    @Override
    public int compareTo(GeoHash o) {
        int bitsCmp = Long.compare(this.bits ^ Long.MIN_VALUE, o.bits ^ Long.MIN_VALUE);
        if (bitsCmp != 0) {
            return bitsCmp;
        }
        return Integer.compare(this.significantBits, o.significantBits);
    }

    static {
        int sz = base32.length;
        for (int i = 0; i < sz; ++i) {
            decodeMap.put(Character.valueOf(base32[i]), i);
        }
    }
}

