/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.extra;

import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.setting.Setting;
import com.xiaoleilu.hutool.util.ClassUtil;
import it.sauronsoftware.cron4j.Scheduler;
import it.sauronsoftware.cron4j.Task;
import java.util.Map;

public class CronUtil {
    public static final String CRONTAB_CONFIG_PATH = "config/cron4j.setting";
    private static final Scheduler scheduler = new Scheduler();
    private static Setting crontabSetting;

    public static void setCronSetting(Setting cronSetting) {
        crontabSetting = cronSetting;
    }

    public static void setCronSetting(String cronSettingPath) {
        crontabSetting = new Setting(cronSettingPath, Setting.DEFAULT_CHARSET, false);
    }

    public static String schedule(String schedulingPattern, Task task) {
        return scheduler.schedule(schedulingPattern, task);
    }

    public static String schedule(String schedulingPattern, Runnable task) {
        return scheduler.schedule(schedulingPattern, task);
    }

    public static void schedule(Setting cronSetting) {
        for (Map.Entry<Object, Object> entry : cronSetting.entrySet()) {
            String jobClass = Convert.toStr(entry.getKey());
            String pattern = Convert.toStr(entry.getValue());
            try {
                Runnable job = (Runnable)ClassUtil.newInstance(jobClass);
                CronUtil.schedule(pattern, job);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void remove(String schedulerId) {
        scheduler.deschedule(schedulerId);
    }

    public Scheduler getScheduler() {
        return scheduler;
    }

    public static synchronized void start() {
        if (null == crontabSetting) {
            CronUtil.setCronSetting(CRONTAB_CONFIG_PATH);
        }
        if (scheduler.isStarted()) {
            throw new UtilException("Scheduler has been started, please stop it first!");
        }
        CronUtil.schedule(crontabSetting);
        scheduler.start();
    }

    public static synchronized void restart() {
        if (null != crontabSetting) {
            crontabSetting.load();
        }
        if (scheduler.isStarted()) {
            scheduler.stop();
        }
        CronUtil.schedule(crontabSetting);
        scheduler.start();
    }

    public static synchronized void stop() {
        scheduler.stop();
    }
}

