/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds.simple;

import com.xiaoleilu.hutool.db.ds.DSFactory;
import com.xiaoleilu.hutool.db.ds.simple.SimpleDataSource;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.setting.Setting;
import com.xiaoleilu.hutool.util.CollectionUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class SimpleDSFactory
extends DSFactory {
    private Setting setting;
    private Map<String, SimpleDataSource> dsMap;

    public SimpleDSFactory() {
        this((Setting)null);
    }

    public SimpleDSFactory(Setting setting) {
        super("Hutool-Simple-Datasource");
        if (null == setting) {
            setting = new Setting("config/db.setting", true);
        }
        this.setting = setting;
        this.dsMap = new ConcurrentHashMap<String, SimpleDataSource>();
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        SimpleDataSource existedDataSource = this.dsMap.get(group);
        if (existedDataSource != null) {
            return existedDataSource;
        }
        SimpleDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        SimpleDataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            IoUtil.close(ds);
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionUtil.isNotEmpty(this.dsMap)) {
            Collection<SimpleDataSource> values = this.dsMap.values();
            for (SimpleDataSource ds : values) {
                IoUtil.close(ds);
            }
            this.dsMap.clear();
            this.dsMap = null;
        }
    }

    private SimpleDataSource createDataSource(String group) {
        SimpleDataSource ds = new SimpleDataSource(this.setting, group);
        return ds;
    }
}

