/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds.pooled;

import com.xiaoleilu.hutool.db.DbRuntimeException;
import com.xiaoleilu.hutool.db.ds.DSFactory;
import com.xiaoleilu.hutool.db.ds.pooled.DbSetting;
import com.xiaoleilu.hutool.db.ds.pooled.PooledDataSource;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.setting.Setting;
import com.xiaoleilu.hutool.util.CollectionUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class PooledDSFactory
extends DSFactory {
    private Setting setting;
    private Map<String, PooledDataSource> dsMap;

    public PooledDSFactory() {
        this((Setting)null);
    }

    public PooledDSFactory(Setting setting) {
        super("Hutool-Pooled-Datasource");
        if (null == setting) {
            setting = new Setting("config/db.setting", true);
        }
        this.setting = setting;
        this.dsMap = new ConcurrentHashMap<String, PooledDataSource>();
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        PooledDataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        PooledDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        PooledDataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            IoUtil.close(ds);
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionUtil.isNotEmpty(this.dsMap)) {
            Collection<PooledDataSource> values = this.dsMap.values();
            for (PooledDataSource ds : values) {
                IoUtil.close(ds);
            }
            this.dsMap.clear();
            this.dsMap = null;
        }
    }

    private PooledDataSource createDataSource(String group) {
        Setting config;
        if (group == null) {
            group = "";
        }
        if (null == (config = this.setting.getSetting(group)) || config.isEmpty()) {
            throw new DbRuntimeException("No PooledDataSource config for group: [{}]", group);
        }
        PooledDataSource ds = new PooledDataSource(new DbSetting(config).getDbConfig(null));
        return ds;
    }
}

