/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds.hikari;

import com.xiaoleilu.hutool.db.DbRuntimeException;
import com.xiaoleilu.hutool.db.ds.DSFactory;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.setting.Setting;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class HikariDSFactory
extends DSFactory {
    private Setting setting;
    private Map<String, HikariDataSource> dsMap;

    public HikariDSFactory() {
        this((Setting)null);
    }

    public HikariDSFactory(Setting setting) {
        super("HikariCP");
        this.checkCPExist(HikariDataSource.class);
        if (null == setting) {
            setting = new Setting("config/db.setting", true);
        }
        this.setting = setting;
        this.dsMap = new ConcurrentHashMap<String, HikariDataSource>();
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        HikariDataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        HikariDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        HikariDataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            IoUtil.close((Closeable)ds);
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionUtil.isNotEmpty(this.dsMap)) {
            Collection<HikariDataSource> values = this.dsMap.values();
            for (HikariDataSource ds : values) {
                IoUtil.close((Closeable)ds);
            }
            this.dsMap.clear();
            this.dsMap = null;
        }
    }

    private HikariDataSource createDataSource(String group) {
        Properties config;
        if (group == null) {
            group = "";
        }
        if (CollectionUtil.isEmpty(config = this.setting.getProperties(group))) {
            throw new DbRuntimeException("No HikariCP config for group: [{}]", group);
        }
        HikariDataSource ds = new HikariDataSource(new HikariConfig(config));
        return ds;
    }
}

