/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds.dbcp;

import com.xiaoleilu.hutool.db.ds.DSFactory;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.setting.Setting;
import com.xiaoleilu.hutool.util.CollectionUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;

public class DbcpDSFactory
extends DSFactory {
    private Setting setting;
    private Map<String, BasicDataSource> dsMap;

    public DbcpDSFactory() {
        this((Setting)null);
    }

    public DbcpDSFactory(Setting setting) {
        super("Commone-DBCP2");
        this.checkCPExist(BasicDataSource.class);
        if (null == setting) {
            setting = new Setting("config/db.setting", true);
        }
        this.setting = setting;
        this.dsMap = new ConcurrentHashMap<String, BasicDataSource>();
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        BasicDataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        BasicDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        BasicDataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            IoUtil.close((AutoCloseable)ds);
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionUtil.isNotEmpty(this.dsMap)) {
            Collection<BasicDataSource> values = this.dsMap.values();
            for (BasicDataSource ds : values) {
                IoUtil.close((AutoCloseable)ds);
            }
            this.dsMap.clear();
            this.dsMap = null;
        }
    }

    private BasicDataSource createDataSource(String group) {
        BasicDataSource ds = new BasicDataSource();
        this.setting.toBean(group, ds);
        return ds;
    }
}

