/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds.c3p0;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.xiaoleilu.hutool.db.DbRuntimeException;
import com.xiaoleilu.hutool.db.ds.DSFactory;
import com.xiaoleilu.hutool.setting.Setting;
import com.xiaoleilu.hutool.util.CollectionUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class C3p0DSFactory
extends DSFactory {
    private Setting setting;
    private Map<String, ComboPooledDataSource> dsMap;

    public C3p0DSFactory() {
        this((Setting)null);
    }

    public C3p0DSFactory(Setting setting) {
        super("C3P0");
        this.checkCPExist(ComboPooledDataSource.class);
        if (null == setting) {
            setting = new Setting("config/db.setting", true);
        }
        this.setting = setting;
        this.dsMap = new ConcurrentHashMap<String, ComboPooledDataSource>();
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        ComboPooledDataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        ComboPooledDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        ComboPooledDataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            ds.close();
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionUtil.isNotEmpty(this.dsMap)) {
            Collection<ComboPooledDataSource> values = this.dsMap.values();
            for (ComboPooledDataSource ds : values) {
                ds.close();
            }
            this.dsMap.clear();
            this.dsMap = null;
        }
    }

    private ComboPooledDataSource createDataSource(String group) {
        Properties config = this.setting.getProperties(group);
        if (CollectionUtil.isEmpty(config)) {
            throw new DbRuntimeException("No Druid config for group: [{}]", group);
        }
        ComboPooledDataSource ds = new ComboPooledDataSource();
        ds.setProperties(config);
        return ds;
    }
}

