/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.collection;

import java.util.HashMap;
import java.util.Map;

public class CaseInsensitiveMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = 4043263744224569870L;

    public CaseInsensitiveMap() {
    }

    public CaseInsensitiveMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CaseInsensitiveMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CaseInsensitiveMap(Map<? extends K, ? extends V> m) {
        this();
        this.putAll(m);
    }

    @Override
    public V get(Object key) {
        return super.get(CaseInsensitiveMap.lowerCaseKey(key));
    }

    @Override
    public V put(K key, V value) {
        return super.put(CaseInsensitiveMap.lowerCaseKey(key), value);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(CaseInsensitiveMap.lowerCaseKey(key));
    }

    private static Object lowerCaseKey(Object key) {
        if (key instanceof CharSequence) {
            key = key.toString().toLowerCase();
        }
        return key;
    }
}

