/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.cache.impl;

import com.xiaoleilu.hutool.cache.Cache;
import com.xiaoleilu.hutool.cache.impl.CacheObj;
import com.xiaoleilu.hutool.cache.impl.CacheValuesIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractCache<K, V>
implements Cache<K, V>,
Iterable<V> {
    protected Map<K, CacheObj<K, V>> cacheMap;
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.cacheLock.readLock();
    private final Lock writeLock = this.cacheLock.writeLock();
    protected int capacity;
    protected long timeout;
    protected boolean existCustomTimeout;
    protected int hitCount;
    protected int missCount;

    @Override
    public void put(K key, V object) {
        this.put(key, object, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V object, long timeout) {
        this.writeLock.lock();
        try {
            CacheObj<K, V> co = new CacheObj<K, V>(key, object, timeout);
            if (timeout != 0L) {
                this.existCustomTimeout = true;
            }
            if (this.isFull()) {
                this.pruneCache();
            }
            this.cacheMap.put(key, co);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public int getMissCount() {
        return this.missCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this.readLock.lock();
        try {
            CacheObj<K, V> co = this.cacheMap.get(key);
            if (co == null) {
                ++this.missCount;
                V v = null;
                return v;
            }
            if (co.isExpired()) {
                this.cacheMap.remove(key);
                ++this.missCount;
                V v = null;
                return v;
            }
            ++this.hitCount;
            V v = co.get();
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Iterator<V> iterator() {
        return new CacheValuesIterator(this);
    }

    protected abstract int pruneCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int prune() {
        this.writeLock.lock();
        try {
            int n = this.pruneCache();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    protected boolean isPruneExpiredActive() {
        return this.timeout != 0L || this.existCustomTimeout;
    }

    @Override
    public boolean isFull() {
        return this.capacity > 0 && this.cacheMap.size() >= this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key) {
        CacheObj<K, V> co;
        this.writeLock.lock();
        try {
            co = this.cacheMap.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
        if (null != co) {
            this.onRemove(co.key, co.obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.cacheMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cacheMap.isEmpty();
    }

    public String toString() {
        return this.cacheMap.toString();
    }

    protected void onRemove(K key, V cachedObject) {
    }
}

