/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.mojo;

import com.webcohesion.enunciate.Enunciate;
import com.webcohesion.enunciate.EnunciateConfiguration;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.EnunciateLogger;
import com.webcohesion.enunciate.module.EnunciateModule;
import com.webcohesion.enunciate.module.ProjectExtensionModule;
import com.webcohesion.enunciate.mojo.Artifact;
import com.webcohesion.enunciate.mojo.DependencySourceSpec;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeSet;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.License;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.xml.sax.SAXException;

@Mojo(name="config", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ConfigMojo
extends AbstractMojo {
    public static final String ENUNCIATE_PROPERTY = "com.webcohesion.enunciate.mojo.ConfigMojo#ENUNCIATE_PROPERTY";
    private static final List<String> SUPPORTED_TYPES = Arrays.asList("jar", "bundle", "eclipse-plugin", "ejb", "ejb-client");
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    protected MavenFileFilter configFilter;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${plugin.artifacts}", required=true, readonly=true)
    protected Collection<org.apache.maven.artifact.Artifact> pluginDependencies;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    protected ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    protected File exportsDir = null;
    @Parameter
    protected Artifact[] artifacts;
    @Parameter
    protected File configFile = null;
    @Parameter(defaultValue="${project.build.directory}/enunciate", property="enunciate.build.directory")
    protected File buildDir = null;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File outputDir = null;
    @Parameter
    protected Map<String, String> exports = new HashMap<String, String>();
    @Parameter
    protected String[] includes;
    @Parameter
    protected String[] excludes;
    @Parameter(name="project-extensions")
    protected String[] projectExtensions;
    @Parameter
    protected String[] compilerArgs;
    @Parameter(property="maven.compiler.source")
    private String source = null;
    @Parameter(property="maven.compiler.target")
    private String target = null;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding = null;
    @Parameter(defaultValue="false", property="enunciate.skip")
    protected boolean skipEnunciate;
    @Parameter(defaultValue="false", property="enunciate.disable.sourcepath")
    protected boolean disableSourcepath = false;
    @Parameter(name="sourcepath-includes")
    protected DependencySourceSpec[] sourcepathIncludes;
    @Parameter(name="sourcepath-excludes")
    protected DependencySourceSpec[] sourcepathExcludes;
    @Parameter(name="sources")
    protected String[] sources;

    public void execute() throws MojoExecutionException {
        String sourceEncoding;
        String targetVersion;
        List licenses;
        List contributors;
        if (this.skipEnunciate) {
            this.getLog().info((CharSequence)"[ENUNCIATE] Skipping enunciate per configuration.");
            return;
        }
        Enunciate enunciate = new Enunciate();
        enunciate.setLogger((EnunciateLogger)new MavenEnunciateLogger());
        enunciate.setBuildDir(this.buildDir);
        EnunciateConfiguration config = enunciate.getConfiguration();
        File configFile = this.configFile;
        if (configFile == null) {
            configFile = new File(this.project.getBasedir(), "enunciate.xml");
        }
        if (configFile.exists()) {
            this.getLog().info((CharSequence)("[ENUNCIATE] Using enunciate configuration at " + configFile.getAbsolutePath()));
            try {
                this.loadConfig(enunciate, configFile);
                config.setBase(configFile.getParentFile());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Problem with enunciate config file " + configFile, e);
            }
        }
        config.setDefaultSlug(this.project.getArtifactId());
        if (this.project.getName() != null && !"".equals(this.project.getName().trim())) {
            StringBuilder description = new StringBuilder("<h1>").append(this.project.getName()).append("</h1>");
            config.setDefaultTitle(this.project.getName());
            if (this.project.getDescription() != null && !"".equals(this.project.getDescription().trim())) {
                description.append("<p>").append(this.project.getDescription()).append("</p>");
            }
            config.setDefaultDescription(description.toString());
        }
        if (this.project.getVersion() != null && !"".equals(this.project.getVersion().trim())) {
            config.setDefaultVersion(this.project.getVersion());
        }
        if ((contributors = this.project.getContributors()) != null && !contributors.isEmpty()) {
            ArrayList<EnunciateConfiguration.Contact> contacts = new ArrayList<EnunciateConfiguration.Contact>(contributors.size());
            for (Object c : contributors) {
                Contributor contributor = (Contributor)c;
                contacts.add(new EnunciateConfiguration.Contact(contributor.getName(), contributor.getUrl(), contributor.getEmail()));
            }
            config.setDefaultContacts(contacts);
        }
        if ((licenses = this.project.getLicenses()) != null && !licenses.isEmpty()) {
            License license = (License)licenses.get(0);
            config.setDefaultApiLicense(new EnunciateConfiguration.License(license.getName(), license.getUrl(), null, null));
        }
        this.setClasspathAndSourcepath(enunciate);
        List<URL> pluginClasspath = this.buildPluginClasspath();
        ServiceLoader<EnunciateModule> moduleLoader = ServiceLoader.load(EnunciateModule.class, new URLClassLoader(pluginClasspath.toArray(new URL[pluginClasspath.size()]), Thread.currentThread().getContextClassLoader()));
        for (EnunciateModule module : moduleLoader) {
            enunciate.addModule(module);
        }
        ArrayList<String> compilerArgs = new ArrayList<String>();
        String sourceVersion = this.findSourceVersion();
        if (sourceVersion != null) {
            compilerArgs.add("-source");
            compilerArgs.add(sourceVersion);
        }
        if ((targetVersion = this.findTargetVersion()) != null) {
            compilerArgs.add("-target");
            compilerArgs.add(targetVersion);
        }
        if ((sourceEncoding = this.encoding) != null) {
            compilerArgs.add("-encoding");
            compilerArgs.add(sourceEncoding);
        }
        if (this.compilerArgs != null) {
            compilerArgs.addAll(Arrays.asList(this.compilerArgs));
        }
        enunciate.getCompilerArgs().addAll(compilerArgs);
        if (this.includes != null) {
            for (String include : this.includes) {
                enunciate.addInclude(include);
            }
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                enunciate.addExclude(exclude);
            }
        }
        if (this.exports != null) {
            for (String exportId : this.exports.keySet()) {
                String filename = this.exports.get(exportId);
                if (filename == null || "".equals(filename)) {
                    throw new MojoExecutionException("Invalid (empty or null) filename for export " + exportId + ".");
                }
                File exportFile = new File(filename);
                if (!exportFile.isAbsolute()) {
                    exportFile = new File(this.exportsDir, filename);
                }
                enunciate.addExport(exportId, exportFile);
            }
        }
        TreeSet<String> enunciateAddedSourceDirs = new TreeSet<String>();
        List modules = enunciate.getModules();
        if (modules != null) {
            TreeSet projectExtensions = new TreeSet(this.projectExtensions == null ? Collections.emptyList() : Arrays.asList(this.projectExtensions));
            for (EnunciateModule module : modules) {
                if (projectExtensions.contains(module.getName()) && module instanceof ProjectExtensionModule) {
                    ProjectExtensionModule extensions = (ProjectExtensionModule)module;
                    for (File projectSource : extensions.getProjectSources()) {
                        String sourceDir = projectSource.getAbsolutePath();
                        enunciateAddedSourceDirs.add(sourceDir);
                        if (this.project.getCompileSourceRoots().contains(sourceDir)) continue;
                        this.getLog().debug((CharSequence)("[ENUNCIATE] Adding '" + sourceDir + "' to the compile source roots."));
                        this.project.addCompileSourceRoot(sourceDir);
                    }
                    for (File testSource : extensions.getProjectTestSources()) {
                        this.project.addTestCompileSourceRoot(testSource.getAbsolutePath());
                    }
                    for (File resourceDir : extensions.getProjectResourceDirectories()) {
                        Resource restResource = new Resource();
                        restResource.setDirectory(resourceDir.getAbsolutePath());
                        this.project.addResource(restResource);
                    }
                    for (File resourceDir : extensions.getProjectTestResourceDirectories()) {
                        Resource resource = new Resource();
                        resource.setDirectory(resourceDir.getAbsolutePath());
                        this.project.addTestResource(resource);
                    }
                }
                this.applyAdditionalConfiguration(module);
            }
        }
        HashSet<File> sourceDirs = new HashSet<File>();
        List<String> sourcePaths = this.sources == null || this.sources.length == 0 ? this.project.getCompileSourceRoots() : Arrays.asList(this.sources);
        for (String sourcePath : sourcePaths) {
            File sourceDir = new File(sourcePath);
            if (!enunciateAddedSourceDirs.contains(sourceDir.getAbsolutePath())) {
                sourceDirs.add(sourceDir);
                continue;
            }
            this.getLog().info((CharSequence)("[ENUNCIATE] " + sourceDir + " appears to be added to the source roots by Enunciate.  Excluding from original source roots...."));
        }
        for (File sourceDir : sourceDirs) {
            enunciate.addSourceDir(sourceDir);
        }
        this.postProcessConfig(enunciate);
        try {
            enunciate.run();
        }
        catch (Exception e) {
            Throwable t = this.unwrap(e);
            if (t instanceof EnunciateException) {
                throw new MojoExecutionException(t.getMessage(), t);
            }
            throw new MojoExecutionException("Error invoking Enunciate.", e);
        }
        if (this.artifacts != null) {
            for (Artifact projectArtifact : this.artifacts) {
                if (projectArtifact.getEnunciateArtifactId() == null) {
                    this.getLog().warn((CharSequence)"[ENUNCIATE] No enunciate export id specified.  Skipping project artifact...");
                    continue;
                }
                com.webcohesion.enunciate.artifacts.Artifact artifact = null;
                for (com.webcohesion.enunciate.artifacts.Artifact enunciateArtifact : enunciate.getArtifacts()) {
                    if (!projectArtifact.getEnunciateArtifactId().equals(enunciateArtifact.getId()) && !enunciateArtifact.getAliases().contains(projectArtifact.getEnunciateArtifactId())) continue;
                    artifact = enunciateArtifact;
                    break;
                }
                if (artifact != null) {
                    try {
                        File tempExportFile = enunciate.createTempFile(this.project.getArtifactId() + "-" + projectArtifact.getClassifier(), projectArtifact.getArtifactType());
                        artifact.exportTo(tempExportFile, enunciate);
                        this.projectHelper.attachArtifact(this.project, projectArtifact.getArtifactType(), projectArtifact.getClassifier(), tempExportFile);
                        continue;
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error exporting Enunciate artifact.", (Exception)e);
                    }
                }
                this.getLog().warn((CharSequence)("[ENUNCIATE] Enunciate artifact '" + projectArtifact.getEnunciateArtifactId() + "' not found in the project..."));
            }
        }
        this.postProcess(enunciate);
        this.getPluginContext().put(ENUNCIATE_PROPERTY, enunciate);
    }

    private Throwable unwrap(Throwable e) {
        while (e != null && !(e instanceof EnunciateException)) {
            e = e.getCause();
        }
        return e;
    }

    protected void postProcess(Enunciate enunciate) {
    }

    protected void applyAdditionalConfiguration(EnunciateModule module) {
    }

    protected String findSourceVersion() {
        String source = this.source;
        if (source == null) {
            List plugins = this.project.getBuildPlugins();
            for (Object plugin : plugins) {
                Xpp3Dom configuration;
                Xpp3Dom sourceConfig;
                if (!(plugin instanceof Plugin) || !"org.apache.maven.plugins".equals(((Plugin)plugin).getGroupId()) || !"maven-compiler-plugin".equals(((Plugin)plugin).getArtifactId()) || !(((Plugin)plugin).getConfiguration() instanceof Xpp3Dom) || (sourceConfig = (configuration = (Xpp3Dom)((Plugin)plugin).getConfiguration()).getChild("source")) == null) continue;
                source = sourceConfig.getValue();
            }
        }
        return source;
    }

    protected String findTargetVersion() {
        String target = this.target;
        if (target == null) {
            List plugins = this.project.getBuildPlugins();
            for (Object plugin : plugins) {
                Xpp3Dom configuration;
                Xpp3Dom targetConfig;
                if (!(plugin instanceof Plugin) || !"org.apache.maven.plugins".equals(((Plugin)plugin).getGroupId()) || !"maven-compiler-plugin".equals(((Plugin)plugin).getArtifactId()) || !(((Plugin)plugin).getConfiguration() instanceof Xpp3Dom) || (targetConfig = (configuration = (Xpp3Dom)((Plugin)plugin).getConfiguration()).getChild("target")) == null) continue;
                target = targetConfig.getValue();
            }
        }
        return target;
    }

    protected List<URL> buildPluginClasspath() throws MojoExecutionException {
        ArrayList<URL> classpath = new ArrayList<URL>();
        for (org.apache.maven.artifact.Artifact next : this.pluginDependencies) {
            try {
                classpath.add(next.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Unable to add artifact " + next + " to the classpath.", (Exception)e);
            }
        }
        return classpath;
    }

    protected void setClasspathAndSourcepath(Enunciate enunciate) throws MojoExecutionException {
        ArrayList<File> classpath = new ArrayList<File>();
        if (this.outputDir != null && this.outputDir.exists() && this.outputDir.isDirectory()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("[ENUNCIATE] Adding " + this.outputDir + " to the enunciate classpath."));
            }
            classpath.add(this.outputDir);
        }
        LinkedHashSet dependencies = new LinkedHashSet();
        dependencies.addAll(this.project.getArtifacts());
        Iterator it = dependencies.iterator();
        while (it.hasNext()) {
            String type;
            org.apache.maven.artifact.Artifact artifact = (org.apache.maven.artifact.Artifact)it.next();
            String artifactScope = artifact.getScope();
            String string = type = artifact.getType() == null ? "jar" : artifact.getType();
            if (!SUPPORTED_TYPES.contains(type)) {
                if (this.getLog().isDebugEnabled()) {
                    Iterator<String> typesIt = SUPPORTED_TYPES.iterator();
                    String types = "";
                    while (typesIt.hasNext()) {
                        types = types + "'" + typesIt.next() + (typesIt.hasNext() ? "', " : "'");
                    }
                    this.getLog().debug((CharSequence)("[ENUNCIATE] Artifact " + artifact + " will be removed from the enunciate classpath because it's of type '" + type + "' and not of type " + types + "."));
                }
                it.remove();
                continue;
            }
            if ("test".equals(artifactScope)) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("[ENUNCIATE] Artifact " + artifact + " will be removed from the enunciate classpath because it's of scope '" + artifactScope + "'."));
                }
                it.remove();
                continue;
            }
            classpath.add(artifact.getFile());
        }
        enunciate.setClasspath(classpath);
        if (!this.disableSourcepath) {
            ArrayList<org.apache.maven.artifact.Artifact> sourcepathDependencies = new ArrayList<org.apache.maven.artifact.Artifact>();
            block4: for (org.apache.maven.artifact.Artifact projectDependency : dependencies) {
                if (projectDependency.getGroupId().equals(this.project.getGroupId())) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("[ENUNCIATE] Attempt will be made to lookup the sources for " + projectDependency + " because it has the same groupId as the current project."));
                    }
                    sourcepathDependencies.add(projectDependency);
                    continue;
                }
                if (this.sourcepathIncludes == null) continue;
                for (DependencySourceSpec include : this.sourcepathIncludes) {
                    if (!include.specifies(projectDependency)) continue;
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("[ENUNCIATE] Attempt will be made to lookup the sources for " + projectDependency + " because it was explicitly included in the plugin configuration."));
                    }
                    sourcepathDependencies.add(projectDependency);
                    continue block4;
                }
            }
            if (this.sourcepathExcludes != null && this.sourcepathExcludes.length > 0) {
                Iterator sourcepathIt = sourcepathDependencies.iterator();
                while (sourcepathIt.hasNext()) {
                    org.apache.maven.artifact.Artifact sourcepathDependency = (org.apache.maven.artifact.Artifact)sourcepathIt.next();
                    for (DependencySourceSpec exclude : this.sourcepathExcludes) {
                        if (!exclude.specifies(sourcepathDependency)) continue;
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((CharSequence)("[ENUNCIATE] Attempt will NOT be made to lookup the sources for " + sourcepathDependency + " because it was explicitly excluded in the plugin configuration."));
                        }
                        sourcepathIt.remove();
                    }
                }
            }
            ArrayList<File> sourcepath = new ArrayList<File>();
            for (org.apache.maven.artifact.Artifact sourcepathDependency : sourcepathDependencies) {
                try {
                    org.apache.maven.artifact.Artifact sourceArtifact = this.artifactFactory.createArtifactWithClassifier(sourcepathDependency.getGroupId(), sourcepathDependency.getArtifactId(), sourcepathDependency.getVersion(), sourcepathDependency.getType(), "sources");
                    this.artifactResolver.resolve(sourceArtifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("[ENUNCIATE] Source artifact found at " + sourceArtifact + "."));
                    }
                    sourcepath.add(sourceArtifact.getFile());
                }
                catch (Exception e) {
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)("[ENUNCIATE] Attempt to find source artifact for " + sourcepathDependency + " failed."));
                }
            }
            enunciate.setSourcepath(sourcepath);
        } else {
            this.getLog().warn((CharSequence)"[ENUNCIATE] Source path has been disabled. This may result is some missing documentation elements because the source code won't be available.");
        }
    }

    protected void postProcessConfig(Enunciate enunciate) {
    }

    protected void loadConfig(Enunciate config, File configFile) throws IOException, SAXException, MavenFilteringException {
        if (this.configFilter == null) {
            this.getLog().debug((CharSequence)"[ENUNCIATE] No maven file filter was provided, so no filtering of the config file will be done.");
            config.loadConfiguration(configFile);
        } else {
            this.buildDir.mkdirs();
            File filteredConfig = File.createTempFile("enunciateConfig", ".xml", this.buildDir);
            this.getLog().debug((CharSequence)("[ENUNCIATE] Filtering " + configFile + " to " + filteredConfig + "..."));
            this.configFilter.copyFile(configFile, filteredConfig, true, this.project, new ArrayList(), true, "utf-8", this.session);
            config.loadConfiguration(filteredConfig);
            config.getConfiguration().setConfigFile(configFile);
        }
    }

    protected class MavenEnunciateLogger
    implements EnunciateLogger {
        protected MavenEnunciateLogger() {
        }

        public void debug(String message, Object ... formatArgs) {
            if (ConfigMojo.this.getLog().isDebugEnabled()) {
                ConfigMojo.this.getLog().debug((CharSequence)("[ENUNCIATE] " + String.format(message, formatArgs)));
            }
        }

        public void info(String message, Object ... formatArgs) {
            if (ConfigMojo.this.getLog().isInfoEnabled()) {
                ConfigMojo.this.getLog().info((CharSequence)("[ENUNCIATE] " + String.format(message, formatArgs)));
            }
        }

        public void warn(String message, Object ... formatArgs) {
            if (ConfigMojo.this.getLog().isWarnEnabled()) {
                ConfigMojo.this.getLog().warn((CharSequence)("[ENUNCIATE] " + String.format(message, formatArgs)));
            }
        }

        public void error(String message, Object ... formatArgs) {
            if (ConfigMojo.this.getLog().isErrorEnabled()) {
                ConfigMojo.this.getLog().error((CharSequence)("[ENUNCIATE] " + String.format(message, formatArgs)));
            }
        }
    }
}

